/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SwitchType {
    LEGACY("legacy"),
    OVS("ovs");

    private static final Logger log;
    private String image;

    private SwitchType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static SwitchType fromValue(String value) {
        try {
            return SwitchType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'SwitchType' enumerated type. Valid values are 'legacy' and 'ovs'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(SwitchType.class);
    }
}

