/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.SchedulingPolicyBuilder;
import org.ovirt.engine.sdk4.builders.SchedulingPolicyUnitBuilder;
import org.ovirt.engine.sdk4.internal.containers.WeightContainer;
import org.ovirt.engine.sdk4.types.SchedulingPolicy;
import org.ovirt.engine.sdk4.types.SchedulingPolicyUnit;
import org.ovirt.engine.sdk4.types.Weight;

public class WeightBuilder {
    private String comment;
    private String description;
    private BigInteger factor;
    private String href;
    private String id;
    private String name;
    private SchedulingPolicy schedulingPolicy;
    private SchedulingPolicyUnit schedulingPolicyUnit;

    public WeightBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public WeightBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public WeightBuilder factor(int newFactor) {
        this.factor = BigInteger.valueOf(newFactor);
        return this;
    }

    public WeightBuilder factor(Integer newFactor) {
        this.factor = newFactor == null ? null : BigInteger.valueOf(newFactor.longValue());
        return this;
    }

    public WeightBuilder factor(long newFactor) {
        this.factor = BigInteger.valueOf(newFactor);
        return this;
    }

    public WeightBuilder factor(Long newFactor) {
        this.factor = newFactor == null ? null : BigInteger.valueOf(newFactor);
        return this;
    }

    public WeightBuilder factor(BigInteger newFactor) {
        this.factor = newFactor;
        return this;
    }

    public WeightBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public WeightBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public WeightBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public WeightBuilder schedulingPolicy(SchedulingPolicy newSchedulingPolicy) {
        this.schedulingPolicy = newSchedulingPolicy;
        return this;
    }

    public WeightBuilder schedulingPolicy(SchedulingPolicyBuilder newSchedulingPolicy) {
        this.schedulingPolicy = newSchedulingPolicy == null ? null : newSchedulingPolicy.build();
        return this;
    }

    public WeightBuilder schedulingPolicyUnit(SchedulingPolicyUnit newSchedulingPolicyUnit) {
        this.schedulingPolicyUnit = newSchedulingPolicyUnit;
        return this;
    }

    public WeightBuilder schedulingPolicyUnit(SchedulingPolicyUnitBuilder newSchedulingPolicyUnit) {
        this.schedulingPolicyUnit = newSchedulingPolicyUnit == null ? null : newSchedulingPolicyUnit.build();
        return this;
    }

    public Weight build() {
        WeightContainer container = new WeightContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.factor(this.factor);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.schedulingPolicy(this.schedulingPolicy);
        container.schedulingPolicyUnit(this.schedulingPolicyUnit);
        return container;
    }
}

