/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ClusterFeatureContainer;
import org.ovirt.engine.sdk4.types.ClusterFeature;
import org.ovirt.engine.sdk4.types.ClusterLevel;

public class ClusterFeatureBuilder {
    private ClusterLevel clusterLevel;
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    
    public ClusterFeatureBuilder clusterLevel(ClusterLevel newClusterLevel) {
        clusterLevel = newClusterLevel;
        return this;
    }
    
    public ClusterFeatureBuilder clusterLevel(ClusterLevelBuilder newClusterLevel) {
        if (newClusterLevel == null) {
            clusterLevel = null;
        }
        else {
            clusterLevel = newClusterLevel.build();
        }
        return this;
    }
    
    
    public ClusterFeatureBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public ClusterFeatureBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public ClusterFeatureBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public ClusterFeatureBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public ClusterFeatureBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ClusterFeature build() {
        ClusterFeatureContainer container = new ClusterFeatureContainer();
        container.clusterLevel(clusterLevel);
        container.comment(comment);
        container.description(description);
        container.href(href);
        container.id(id);
        container.name(name);
        return container;
    }
}
