/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.IpContainer;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.IpVersion;

public class IpBuilder {
    private String address;
    private String gateway;
    private String netmask;
    private IpVersion version;
    
    public IpBuilder address(String newAddress) {
        address = newAddress;
        return this;
    }
    
    
    public IpBuilder gateway(String newGateway) {
        gateway = newGateway;
        return this;
    }
    
    
    public IpBuilder netmask(String newNetmask) {
        netmask = newNetmask;
        return this;
    }
    
    
    public IpBuilder version(IpVersion newVersion) {
        version = newVersion;
        return this;
    }
    
    
    public Ip build() {
        IpContainer container = new IpContainer();
        container.address(address);
        container.gateway(gateway);
        container.netmask(netmask);
        container.version(version);
        return container;
    }
}
