/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NetworkStatus {
    NON_OPERATIONAL("non_operational"),
    OPERATIONAL("operational");

    private static final Logger log;
    private String image;

    private NetworkStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static NetworkStatus fromValue(String value) {
        try {
            return NetworkStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'NetworkStatus' enumerated type. Valid values are 'non_operational' and 'operational'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(NetworkStatus.class);
    }
}

