/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.GraphicsConsoleContainer;
import org.ovirt.engine.sdk4.types.GraphicsConsole;
import org.ovirt.engine.sdk4.types.GraphicsType;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class GraphicsConsoleBuilder {
    private String address;
    private String comment;
    private String description;
    private String href;
    private String id;
    private InstanceType instanceType;
    private String name;
    private BigInteger port;
    private GraphicsType protocol;
    private Template template;
    private BigInteger tlsPort;
    private Vm vm;

    public GraphicsConsoleBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public GraphicsConsoleBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public GraphicsConsoleBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GraphicsConsoleBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public GraphicsConsoleBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public GraphicsConsoleBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public GraphicsConsoleBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public GraphicsConsoleBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public GraphicsConsoleBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public GraphicsConsoleBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public GraphicsConsoleBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public GraphicsConsoleBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public GraphicsConsoleBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public GraphicsConsoleBuilder protocol(GraphicsType newProtocol) {
        this.protocol = newProtocol;
        return this;
    }

    public GraphicsConsoleBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public GraphicsConsoleBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public GraphicsConsoleBuilder tlsPort(int newTlsPort) {
        this.tlsPort = BigInteger.valueOf(newTlsPort);
        return this;
    }

    public GraphicsConsoleBuilder tlsPort(Integer newTlsPort) {
        this.tlsPort = newTlsPort == null ? null : BigInteger.valueOf(newTlsPort.longValue());
        return this;
    }

    public GraphicsConsoleBuilder tlsPort(long newTlsPort) {
        this.tlsPort = BigInteger.valueOf(newTlsPort);
        return this;
    }

    public GraphicsConsoleBuilder tlsPort(Long newTlsPort) {
        this.tlsPort = newTlsPort == null ? null : BigInteger.valueOf(newTlsPort);
        return this;
    }

    public GraphicsConsoleBuilder tlsPort(BigInteger newTlsPort) {
        this.tlsPort = newTlsPort;
        return this;
    }

    public GraphicsConsoleBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public GraphicsConsoleBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public GraphicsConsole build() {
        GraphicsConsoleContainer container = new GraphicsConsoleContainer();
        container.address(this.address);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.name(this.name);
        container.port(this.port);
        container.protocol(this.protocol);
        container.template(this.template);
        container.tlsPort(this.tlsPort);
        container.vm(this.vm);
        return container;
    }
}

