/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StepStatus {
    ABORTED("aborted"),
    FAILED("failed"),
    FINISHED("finished"),
    STARTED("started"),
    UNKNOWN("unknown");

    private static final Logger log;
    private String image;

    private StepStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StepStatus fromValue(String value) {
        try {
            return StepStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StepStatus' enumerated type. Valid values are 'aborted', 'failed', 'finished', 'started' and 'unknown'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StepStatus.class);
    }
}

