/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HostType {
    OVIRT_NODE("ovirt_node"),
    RHEL("rhel"),
    RHEV_H("rhev_h");

    private static final Logger log;
    private String image;

    private HostType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static HostType fromValue(String value) {
        try {
            return HostType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'HostType' enumerated type. Valid values are 'ovirt_node', 'rhel' and 'rhev_h'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(HostType.class);
    }
}

