/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GraphicsType {
    SPICE("spice"),
    VNC("vnc");

    private static final Logger log;
    private String image;

    private GraphicsType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static GraphicsType fromValue(String value) {
        try {
            return GraphicsType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'GraphicsType' enumerated type. Valid values are 'spice' and 'vnc'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(GraphicsType.class);
    }
}

