/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExternalSystemType {
    GLUSTER("gluster"),
    VDSM("vdsm");

    private static final Logger log;
    private String image;

    private ExternalSystemType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ExternalSystemType fromValue(String value) {
        try {
            return ExternalSystemType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ExternalSystemType' enumerated type. Valid values are 'gluster' and 'vdsm'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ExternalSystemType.class);
    }
}

