/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExternalStatus {
    ERROR("error"),
    FAILURE("failure"),
    INFO("info"),
    OK("ok"),
    WARNING("warning");

    private static final Logger log;
    private String image;

    private ExternalStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ExternalStatus fromValue(String value) {
        try {
            return ExternalStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ExternalStatus' enumerated type. Valid values are 'error', 'failure', 'info', 'ok' and 'warning'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ExternalStatus.class);
    }
}

