/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BootProtocol {
    AUTOCONF("autoconf"),
    DHCP("dhcp"),
    NONE("none"),
    STATIC("static");

    private static final Logger log;
    private String image;

    private BootProtocol(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static BootProtocol fromValue(String value) {
        try {
            return BootProtocol.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'BootProtocol' enumerated type. Valid values are 'autoconf', 'dhcp', 'none' and 'static'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(BootProtocol.class);
    }
}

