/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HostContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAutoNumaStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDeviceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDisplayReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalNetworkProviderConfigurationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHardwareInformationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHookReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostDevicePassthroughReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostNicReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostProtocolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStorageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostedEngineReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIscsiDetailsReader;
import org.ovirt.engine.sdk4.internal.xml.XmlKatelloErratumReader;
import org.ovirt.engine.sdk4.internal.xml.XmlKdumpStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlKsmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNumaNodeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOperatingSystemReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPowerManagementReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSeLinuxReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSpmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSshReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionExtensionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTagReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTransparentHugePagesReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUnmanagedNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVersionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmSummaryReader;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.Agent;
import org.ovirt.engine.sdk4.types.Device;
import org.ovirt.engine.sdk4.types.ExternalNetworkProviderConfiguration;
import org.ovirt.engine.sdk4.types.Hook;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.KatelloErratum;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.NumaNode;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageConnectionExtension;
import org.ovirt.engine.sdk4.types.Tag;
import org.ovirt.engine.sdk4.types.UnmanagedNetwork;

public class XmlHostReader {
    public static Host readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        HostContainer object = new HostContainer();
        block118: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block118;
                }
                case "id": {
                    object.id(image);
                    continue block118;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block119: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block119;
                }
                case "affinity_labels": {
                    object.affinityLabels(XmlAffinityLabelReader.readMany(reader));
                    continue block119;
                }
                case "agents": {
                    object.agents(XmlAgentReader.readMany(reader));
                    continue block119;
                }
                case "auto_numa_status": {
                    object.autoNumaStatus(XmlAutoNumaStatusReader.readOne(reader));
                    continue block119;
                }
                case "certificate": {
                    object.certificate(XmlCertificateReader.readOne(reader));
                    continue block119;
                }
                case "cluster": {
                    object.cluster(XmlClusterReader.readOne(reader));
                    continue block119;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block119;
                }
                case "cpu": {
                    object.cpu(XmlCpuReader.readOne(reader));
                    continue block119;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block119;
                }
                case "device_passthrough": {
                    object.devicePassthrough(XmlHostDevicePassthroughReader.readOne(reader));
                    continue block119;
                }
                case "devices": {
                    object.devices(XmlDeviceReader.readMany(reader));
                    continue block119;
                }
                case "display": {
                    object.display(XmlDisplayReader.readOne(reader));
                    continue block119;
                }
                case "external_host_provider": {
                    object.externalHostProvider(XmlExternalHostProviderReader.readOne(reader));
                    continue block119;
                }
                case "external_network_provider_configurations": {
                    object.externalNetworkProviderConfigurations(XmlExternalNetworkProviderConfigurationReader.readMany(reader));
                    continue block119;
                }
                case "external_status": {
                    object.externalStatus(XmlExternalStatusReader.readOne(reader));
                    continue block119;
                }
                case "hardware_information": {
                    object.hardwareInformation(XmlHardwareInformationReader.readOne(reader));
                    continue block119;
                }
                case "hooks": {
                    object.hooks(XmlHookReader.readMany(reader));
                    continue block119;
                }
                case "hosted_engine": {
                    object.hostedEngine(XmlHostedEngineReader.readOne(reader));
                    continue block119;
                }
                case "iscsi": {
                    object.iscsi(XmlIscsiDetailsReader.readOne(reader));
                    continue block119;
                }
                case "katello_errata": {
                    object.katelloErrata(XmlKatelloErratumReader.readMany(reader));
                    continue block119;
                }
                case "kdump_status": {
                    object.kdumpStatus(XmlKdumpStatusReader.readOne(reader));
                    continue block119;
                }
                case "ksm": {
                    object.ksm(XmlKsmReader.readOne(reader));
                    continue block119;
                }
                case "libvirt_version": {
                    object.libvirtVersion(XmlVersionReader.readOne(reader));
                    continue block119;
                }
                case "max_scheduling_memory": {
                    object.maxSchedulingMemory(reader.readInteger());
                    continue block119;
                }
                case "memory": {
                    object.memory(reader.readInteger());
                    continue block119;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block119;
                }
                case "network_attachments": {
                    object.networkAttachments(XmlNetworkAttachmentReader.readMany(reader));
                    continue block119;
                }
                case "nics": {
                    object.nics(XmlHostNicReader.readMany(reader));
                    continue block119;
                }
                case "host_numa_nodes": {
                    object.numaNodes(XmlNumaNodeReader.readMany(reader));
                    continue block119;
                }
                case "numa_supported": {
                    object.numaSupported(reader.readBoolean());
                    continue block119;
                }
                case "os": {
                    object.os(XmlOperatingSystemReader.readOne(reader));
                    continue block119;
                }
                case "override_iptables": {
                    object.overrideIptables(reader.readBoolean());
                    continue block119;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block119;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block119;
                }
                case "power_management": {
                    object.powerManagement(XmlPowerManagementReader.readOne(reader));
                    continue block119;
                }
                case "protocol": {
                    object.protocol(XmlHostProtocolReader.readOne(reader));
                    continue block119;
                }
                case "root_password": {
                    object.rootPassword(reader.readString());
                    continue block119;
                }
                case "se_linux": {
                    object.seLinux(XmlSeLinuxReader.readOne(reader));
                    continue block119;
                }
                case "spm": {
                    object.spm(XmlSpmReader.readOne(reader));
                    continue block119;
                }
                case "ssh": {
                    object.ssh(XmlSshReader.readOne(reader));
                    continue block119;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block119;
                }
                case "status": {
                    object.status(XmlHostStatusReader.readOne(reader));
                    continue block119;
                }
                case "status_detail": {
                    object.statusDetail(reader.readString());
                    continue block119;
                }
                case "storage_connection_extensions": {
                    object.storageConnectionExtensions(XmlStorageConnectionExtensionReader.readMany(reader));
                    continue block119;
                }
                case "storages": {
                    object.storages(XmlHostStorageReader.readMany(reader));
                    continue block119;
                }
                case "summary": {
                    object.summary(XmlVmSummaryReader.readOne(reader));
                    continue block119;
                }
                case "tags": {
                    object.tags(XmlTagReader.readMany(reader));
                    continue block119;
                }
                case "transparent_hugepages": {
                    object.transparentHugePages(XmlTransparentHugePagesReader.readOne(reader));
                    continue block119;
                }
                case "type": {
                    object.type(XmlHostTypeReader.readOne(reader));
                    continue block119;
                }
                case "unmanaged_networks": {
                    object.unmanagedNetworks(XmlUnmanagedNetworkReader.readMany(reader));
                    continue block119;
                }
                case "update_available": {
                    object.updateAvailable(reader.readBoolean());
                    continue block119;
                }
                case "version": {
                    object.version(XmlVersionReader.readOne(reader));
                    continue block119;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block119;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHostReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Host> iterateMany(final XmlReader reader) {
        return new Iterator<Host>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Host next() {
                Host next = XmlHostReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Host> readMany(XmlReader reader) {
        ArrayList<Host> list = new ArrayList<Host>();
        Iterator<Host> iterator = XmlHostReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HostContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "affinitylabels": {
                    ArrayListWithHref<AffinityLabel> list = new ArrayListWithHref<AffinityLabel>(object.affinityLabels());
                    list.href(href);
                    object.affinityLabels(list);
                    break;
                }
                case "agents": {
                    ArrayListWithHref<Agent> list = new ArrayListWithHref<Agent>(object.agents());
                    list.href(href);
                    object.agents(list);
                    break;
                }
                case "devices": {
                    ArrayListWithHref<Device> list = new ArrayListWithHref<Device>(object.devices());
                    list.href(href);
                    object.devices(list);
                    break;
                }
                case "externalnetworkproviderconfigurations": {
                    ArrayListWithHref<ExternalNetworkProviderConfiguration> list = new ArrayListWithHref<ExternalNetworkProviderConfiguration>(object.externalNetworkProviderConfigurations());
                    list.href(href);
                    object.externalNetworkProviderConfigurations(list);
                    break;
                }
                case "hooks": {
                    ArrayListWithHref<Hook> list = new ArrayListWithHref<Hook>(object.hooks());
                    list.href(href);
                    object.hooks(list);
                    break;
                }
                case "katelloerrata": {
                    ArrayListWithHref<KatelloErratum> list = new ArrayListWithHref<KatelloErratum>(object.katelloErrata());
                    list.href(href);
                    object.katelloErrata(list);
                    break;
                }
                case "networkattachments": {
                    ArrayListWithHref<NetworkAttachment> list = new ArrayListWithHref<NetworkAttachment>(object.networkAttachments());
                    list.href(href);
                    object.networkAttachments(list);
                    break;
                }
                case "nics": {
                    ArrayListWithHref<HostNic> list = new ArrayListWithHref<HostNic>(object.nics());
                    list.href(href);
                    object.nics(list);
                    break;
                }
                case "numanodes": {
                    ArrayListWithHref<NumaNode> list = new ArrayListWithHref<NumaNode>(object.numaNodes());
                    list.href(href);
                    object.numaNodes(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
                case "storageconnectionextensions": {
                    ArrayListWithHref<StorageConnectionExtension> list = new ArrayListWithHref<StorageConnectionExtension>(object.storageConnectionExtensions());
                    list.href(href);
                    object.storageConnectionExtensions(list);
                    break;
                }
                case "storages": {
                    ArrayListWithHref<HostStorage> list = new ArrayListWithHref<HostStorage>(object.storages());
                    list.href(href);
                    object.storages(list);
                    break;
                }
                case "tags": {
                    ArrayListWithHref<Tag> list = new ArrayListWithHref<Tag>(object.tags());
                    list.href(href);
                    object.tags(list);
                    break;
                }
                case "unmanagednetworks": {
                    ArrayListWithHref<UnmanagedNetwork> list = new ArrayListWithHref<UnmanagedNetwork>(object.unmanagedNetworks());
                    list.href(href);
                    object.unmanagedNetworks(list);
                    break;
                }
            }
        }
    }
}

