/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.CustomPropertyContainer;
import org.ovirt.engine.sdk4.types.CustomProperty;

public class XmlCustomPropertyReader {
    public static CustomProperty readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        CustomPropertyContainer object = new CustomPropertyContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block12: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "name": {
                    object.name(reader.readString());
                    continue block12;
                }
                case "regexp": {
                    object.regexp(reader.readString());
                    continue block12;
                }
                case "value": {
                    object.value(reader.readString());
                    continue block12;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block12;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlCustomPropertyReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<CustomProperty> iterateMany(final XmlReader reader) {
        return new Iterator<CustomProperty>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public CustomProperty next() {
                CustomProperty next = XmlCustomPropertyReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<CustomProperty> readMany(XmlReader reader) {
        ArrayList<CustomProperty> list = new ArrayList<CustomProperty>();
        Iterator<CustomProperty> iterator = XmlCustomPropertyReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(CustomPropertyContainer object, String[] link) {
    }
}

