/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;

public interface Version extends Identified {
    BigInteger build();
    Byte buildAsByte();
    Short buildAsShort();
    Integer buildAsInteger();
    Long buildAsLong();
    
    boolean buildPresent();
    
    String fullVersion();
    
    boolean fullVersionPresent();
    
    BigInteger major();
    Byte majorAsByte();
    Short majorAsShort();
    Integer majorAsInteger();
    Long majorAsLong();
    
    boolean majorPresent();
    
    BigInteger minor();
    Byte minorAsByte();
    Short minorAsShort();
    Integer minorAsInteger();
    Long minorAsLong();
    
    boolean minorPresent();
    
    BigInteger revision();
    Byte revisionAsByte();
    Short revisionAsShort();
    Integer revisionAsInteger();
    Long revisionAsLong();
    
    boolean revisionPresent();
    
}
