/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.builders.BootBuilder;
import org.ovirt.engine.sdk4.builders.VersionBuilder;
import org.ovirt.engine.sdk4.internal.containers.OperatingSystemContainer;
import org.ovirt.engine.sdk4.types.Boot;
import org.ovirt.engine.sdk4.types.OperatingSystem;
import org.ovirt.engine.sdk4.types.Version;

public class OperatingSystemBuilder {
    private Boot boot;
    private String cmdline;
    private String customKernelCmdline;
    private String initrd;
    private String kernel;
    private String reportedKernelCmdline;
    private String type;
    private Version version;

    public OperatingSystemBuilder boot(Boot newBoot) {
        this.boot = newBoot;
        return this;
    }

    public OperatingSystemBuilder boot(BootBuilder newBoot) {
        this.boot = newBoot == null ? null : newBoot.build();
        return this;
    }

    public OperatingSystemBuilder cmdline(String newCmdline) {
        this.cmdline = newCmdline;
        return this;
    }

    public OperatingSystemBuilder customKernelCmdline(String newCustomKernelCmdline) {
        this.customKernelCmdline = newCustomKernelCmdline;
        return this;
    }

    public OperatingSystemBuilder initrd(String newInitrd) {
        this.initrd = newInitrd;
        return this;
    }

    public OperatingSystemBuilder kernel(String newKernel) {
        this.kernel = newKernel;
        return this;
    }

    public OperatingSystemBuilder reportedKernelCmdline(String newReportedKernelCmdline) {
        this.reportedKernelCmdline = newReportedKernelCmdline;
        return this;
    }

    public OperatingSystemBuilder type(String newType) {
        this.type = newType;
        return this;
    }

    public OperatingSystemBuilder version(Version newVersion) {
        this.version = newVersion;
        return this;
    }

    public OperatingSystemBuilder version(VersionBuilder newVersion) {
        this.version = newVersion == null ? null : newVersion.build();
        return this;
    }

    public OperatingSystem build() {
        OperatingSystemContainer container = new OperatingSystemContainer();
        container.boot(this.boot);
        container.cmdline(this.cmdline);
        container.customKernelCmdline(this.customKernelCmdline);
        container.initrd(this.initrd);
        container.kernel(this.kernel);
        container.reportedKernelCmdline(this.reportedKernelCmdline);
        container.type(this.type);
        container.version(this.version);
        return container;
    }
}

