/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ExternalHostProviderContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalComputeResourceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalDiscoveredHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostGroupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.ExternalComputeResource;
import org.ovirt.engine.sdk4.types.ExternalDiscoveredHost;
import org.ovirt.engine.sdk4.types.ExternalHostGroup;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;
import org.ovirt.engine.sdk4.types.Host;

public class XmlExternalHostProviderReader {
    public static ExternalHostProvider readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        ExternalHostProviderContainer object = new ExternalHostProviderContainer();
        block42: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block42;
                }
                case "id": {
                    object.id(image);
                    continue block42;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block43: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "authentication_url": {
                    object.authenticationUrl(reader.readString());
                    continue block43;
                }
                case "certificates": {
                    object.certificates(XmlCertificateReader.readMany(reader));
                    continue block43;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block43;
                }
                case "compute_resources": {
                    object.computeResources(XmlExternalComputeResourceReader.readMany(reader));
                    continue block43;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block43;
                }
                case "discovered_hosts": {
                    object.discoveredHosts(XmlExternalDiscoveredHostReader.readMany(reader));
                    continue block43;
                }
                case "host_groups": {
                    object.hostGroups(XmlExternalHostGroupReader.readMany(reader));
                    continue block43;
                }
                case "hosts": {
                    object.hosts(XmlHostReader.readMany(reader));
                    continue block43;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block43;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block43;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block43;
                }
                case "requires_authentication": {
                    object.requiresAuthentication(reader.readBoolean());
                    continue block43;
                }
                case "url": {
                    object.url(reader.readString());
                    continue block43;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block43;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block43;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlExternalHostProviderReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<ExternalHostProvider> iterateMany(final XmlReader reader) {
        return new Iterator<ExternalHostProvider>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public ExternalHostProvider next() {
                ExternalHostProvider next = XmlExternalHostProviderReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<ExternalHostProvider> readMany(XmlReader reader) {
        ArrayList<ExternalHostProvider> list = new ArrayList<ExternalHostProvider>();
        Iterator<ExternalHostProvider> iterator = XmlExternalHostProviderReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ExternalHostProviderContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "certificates": {
                    ArrayListWithHref<Certificate> list = new ArrayListWithHref<Certificate>(object.certificates());
                    list.href(href);
                    object.certificates(list);
                    break;
                }
                case "computeresources": {
                    ArrayListWithHref<ExternalComputeResource> list = new ArrayListWithHref<ExternalComputeResource>(object.computeResources());
                    list.href(href);
                    object.computeResources(list);
                    break;
                }
                case "discoveredhosts": {
                    ArrayListWithHref<ExternalDiscoveredHost> list = new ArrayListWithHref<ExternalDiscoveredHost>(object.discoveredHosts());
                    list.href(href);
                    object.discoveredHosts(list);
                    break;
                }
                case "hostgroups": {
                    ArrayListWithHref<ExternalHostGroup> list = new ArrayListWithHref<ExternalHostGroup>(object.hostGroups());
                    list.href(href);
                    object.hostGroups(list);
                    break;
                }
                case "hosts": {
                    ArrayListWithHref<Host> list = new ArrayListWithHref<Host>(object.hosts());
                    list.href(href);
                    object.hosts(list);
                    break;
                }
            }
        }
    }
}

