/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.SchedulingPolicyUnitBuilder;
import org.ovirt.engine.sdk4.internal.containers.FilterContainer;
import org.ovirt.engine.sdk4.types.Filter;
import org.ovirt.engine.sdk4.types.SchedulingPolicyUnit;

public class FilterBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private BigInteger position;
    private SchedulingPolicyUnit schedulingPolicyUnit;

    public FilterBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public FilterBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public FilterBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public FilterBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public FilterBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public FilterBuilder position(int newPosition) {
        this.position = BigInteger.valueOf(newPosition);
        return this;
    }

    public FilterBuilder position(Integer newPosition) {
        this.position = newPosition == null ? null : BigInteger.valueOf(newPosition.longValue());
        return this;
    }

    public FilterBuilder position(long newPosition) {
        this.position = BigInteger.valueOf(newPosition);
        return this;
    }

    public FilterBuilder position(Long newPosition) {
        this.position = newPosition == null ? null : BigInteger.valueOf(newPosition);
        return this;
    }

    public FilterBuilder position(BigInteger newPosition) {
        this.position = newPosition;
        return this;
    }

    public FilterBuilder schedulingPolicyUnit(SchedulingPolicyUnit newSchedulingPolicyUnit) {
        this.schedulingPolicyUnit = newSchedulingPolicyUnit;
        return this;
    }

    public FilterBuilder schedulingPolicyUnit(SchedulingPolicyUnitBuilder newSchedulingPolicyUnit) {
        this.schedulingPolicyUnit = newSchedulingPolicyUnit == null ? null : newSchedulingPolicyUnit.build();
        return this;
    }

    public Filter build() {
        FilterContainer container = new FilterContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.position(this.position);
        container.schedulingPolicyUnit(this.schedulingPolicyUnit);
        return container;
    }
}

