/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.StepContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalSystemTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlJobReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStepEnumReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStepStatusReader;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Step;

public class XmlStepReader {
    public static Step readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        StepContainer object = new StepContainer();
        block44: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block44;
                }
                case "id": {
                    object.id(image);
                    continue block44;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block45: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block45;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block45;
                }
                case "end_time": {
                    object.endTime(reader.readDate());
                    continue block45;
                }
                case "execution_host": {
                    object.executionHost(XmlHostReader.readOne(reader));
                    continue block45;
                }
                case "external": {
                    object.external(reader.readBoolean());
                    continue block45;
                }
                case "external_type": {
                    object.externalType(XmlExternalSystemTypeReader.readOne(reader));
                    continue block45;
                }
                case "job": {
                    object.job(XmlJobReader.readOne(reader));
                    continue block45;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block45;
                }
                case "number": {
                    object.number(reader.readInteger());
                    continue block45;
                }
                case "parent_step": {
                    object.parentStep(XmlStepReader.readOne(reader));
                    continue block45;
                }
                case "progress": {
                    object.progress(reader.readInteger());
                    continue block45;
                }
                case "start_time": {
                    object.startTime(reader.readDate());
                    continue block45;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block45;
                }
                case "status": {
                    object.status(XmlStepStatusReader.readOne(reader));
                    continue block45;
                }
                case "type": {
                    object.type(XmlStepEnumReader.readOne(reader));
                    continue block45;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block45;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlStepReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Step> iterateMany(final XmlReader reader) {
        return new Iterator<Step>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Step next() {
                Step next = XmlStepReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Step> readMany(XmlReader reader) {
        ArrayList<Step> list = new ArrayList<Step>();
        Iterator<Step> iterator = XmlStepReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(StepContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
            }
        }
    }
}

