/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.NetworkLabelContainer;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkLabel;

public class NetworkLabelBuilder {
    private String comment;
    private String description;
    private HostNic hostNic;
    private String href;
    private String id;
    private String name;
    private Network network;
    
    public NetworkLabelBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public NetworkLabelBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public NetworkLabelBuilder hostNic(HostNic newHostNic) {
        hostNic = newHostNic;
        return this;
    }
    
    public NetworkLabelBuilder hostNic(HostNicBuilder newHostNic) {
        if (newHostNic == null) {
            hostNic = null;
        }
        else {
            hostNic = newHostNic.build();
        }
        return this;
    }
    
    
    public NetworkLabelBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public NetworkLabelBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public NetworkLabelBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public NetworkLabelBuilder network(Network newNetwork) {
        network = newNetwork;
        return this;
    }
    
    public NetworkLabelBuilder network(NetworkBuilder newNetwork) {
        if (newNetwork == null) {
            network = null;
        }
        else {
            network = newNetwork.build();
        }
        return this;
    }
    
    
    public NetworkLabel build() {
        NetworkLabelContainer container = new NetworkLabelContainer();
        container.comment(comment);
        container.description(description);
        container.hostNic(hostNic);
        container.href(href);
        container.id(id);
        container.name(name);
        container.network(network);
        return container;
    }
}
