/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

 import type {
    DoubleColumnForm,
    DoubleColumnFormSection,
    InternationalizationAPI,
    UIHandlerId,
  } from "@gnu-taler/web-util/browser";
  
  export const nameAndDob = (i18n: InternationalizationAPI): DoubleColumnForm => ({
    type: "double-column" as const,
    design: [
      {
        title: i18n.str`Simple form`,
        fields: [
          {
            type: "textArea",
            id: ".full_name" as UIHandlerId,
            name: "full_name",
            label: i18n.str`Full Name`,
          },
          {
            type: "textArea",
            id: ".birthdate" as UIHandlerId,
            name: "birthdate",
            label: i18n.str`Birthdate`,
          },
        ],
      },
    ],
  });
  
  