/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRGUPPISINK_H_
#define _VRGUPPISINK_H_

extern "C" {
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
}

#include <VrSink.h>
#include <guppi.h>

template<class iType> 
class VrGuppiSink : public VrSink<iType>  {
private:
  int gupfd;
  int bytes;
protected:
  int getGupfd() {return gupfd;}
public: 
  /*  virtual float memoryTouchedPerOutput() {return 0.0;}*/
  virtual void work(int units);
  virtual void initialize();
  VrGuppiSink(int b);  
  ~VrGuppiSink();  
};


template<class iType> void
VrGuppiSink<iType>::work(int units) 
{

  //  int total = 0;
  int count = 0;

  while(units>0) {
    int u = units;
    if(units>getHistory())
      u=getHistory();
    int bytes = u*sizeof(iType);
    
    iType *myPtr = inputReadPtr(-u+1);
  
    count =  write(gupfd,myPtr,bytes);
    while ((count < 0) && (errno == EAGAIN)) {
      yield();
      count =  write(gupfd,myPtr,bytes);
    }

    //printf("%d %p\n", u, (void *) myPtr);

    if(count<0) {
      fprintf(stderr, "Guppi write error, count %d errno:%d\n", count, errno);
      //incReadPtr(-u);
      exit(1);
    } else {
      /*if(count!=bytes)
        fprintf(stderr, "VrConnect.fileWrite(): warning: not all bytes written!\n");
      */
      //    total+=count;
      units-=u;
    }
    incReadPtr(u);
  }

}

template<class iType> void
VrGuppiSink<iType>::initialize()
{
  setHistory ( bytes / sizeof(iType));
  setHistoryExact (1);
}

template<class iType> 
VrGuppiSink<iType>::VrGuppiSink(int b)
  :gupfd(-1),bytes(b)
{
  setOutputSize ( bytes / sizeof(iType));
  if ((b % PAGE_SIZE) != 0) {
    fprintf(stderr, "VrGuppiSink: buffer size not an integral number of pages\n");
    exit(1);
  }
  if ((gupfd = open("/dev/guppi0", (O_WRONLY | O_NONBLOCK))) < 0) {
    fprintf(stderr, "VrGuppiSink: Error opening guppi, errno = %d\n", errno);
    exit(1);
  }
}

template<class iType> 
VrGuppiSink<iType>::~VrGuppiSink() { }

#endif










