/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <cppunit/TestAssert.h>
#include <qa_gr_fir.h>
#include <VrComplex.h>
#include <string.h>

typedef gr_fir<short,short,short>		sss_fir_t;
typedef gr_fir<float,float,float>		fff_fir_t;
typedef gr_fir<VrComplex,short,VrComplex>	csc_fir_t;

#define	NELEM(x) (sizeof (x) / sizeof (x[0]))

const static short input_1[] = {
  234,  -4,  23,  -56,  45,    98,  -23,  -7
};

const static short taps_1a[] = {
  -3
};

const static short expected_1a[] = {
  -702, 12, -69,   168, -135, -294,  69,  21
};

const static short taps_1b[] = {  // taps are in "backwards order"
  5, -4
};

const static short expected_1b[] = {
  1186, -112, 339, -460, -167, 582, -87
};


void
qa_gr_fir::t1 ()
{
  vector<short> t1a (&taps_1a[0], &taps_1a[NELEM (taps_1a)]);
  vector<short> t1b (&taps_1b[0], &taps_1b[NELEM (taps_1b)]);
  
  sss_fir_t f1 (t1a);			// create filter
  assertLongsEqual (1, f1.ntaps ());	// check ntaps

  // check filter output
  int n = NELEM (input_1) - f1.ntaps () + 1;
  for (int i = 0; i < n; i++)
    assertLongsEqual (expected_1a[i], f1.filter (&input_1[i]));

  f1.set_taps (t1b);			// set new taps
  assertLongsEqual (2, f1.ntaps ());	// check ntaps
  
  // check filter output
  n = NELEM (input_1) - f1.ntaps () + 1;
  for (int i = 0; i < n; i++)
    assertLongsEqual (expected_1b[i], f1.filter (&input_1[i]));


  // test filterN interface

  short output[NELEM (expected_1b)];
  memset (output, 0, sizeof (output));

  f1.filterN (output, input_1, n);
  for (int i = 0; i < n; i++)
    assertLongsEqual (expected_1b[i], output[i]);
}
