/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore2.BacktraceState;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterThreadV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.JobMessage;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RegionDirection;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import com.sun.electric.tool.routing.experimentalLeeMoore2.Vector2i;
import com.sun.electric.tool.routing.experimentalLeeMoore2.WeightLengthPair;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CyclicBarrier;

public class GlobalRouterV3 {
    int num_threads;
    CyclicBarrier barrier;
    double tileSize;
    int max_detour = 6;
    double via_cost = 0.2;
    public HashMap<Integer, RouteToStitch> output_coarse_routes;
    public RegionToRoute[] output_regions;
    RegionRepresentation[] regions;
    int regions_x;
    int regions_y;
    double region_width;
    double region_height;
    double offset_x;
    double offset_y;
    int max_supply_vertical;
    int max_supply_horizontal;
    private ArrayList<JobMessage> segment_jobs;
    SegmentRepresentation[] segments;
    ArrayList<RoutingFrame.RoutingSegment> electric_segments;
    Integer demand_seg_index;
    Integer remove_failed_index;
    ArrayList<SegBtPair> seg_backtraces;
    public ArrayList<Integer> not_routed;
    Integer regions_in_work;
    ArrayList<Integer> to_reroute;
    List<Integer> wiried_routes = new LinkedList<Integer>();

    public synchronized void OfferCoarseRoute(List<SegPart> route, int seg_id, ArrayList<Vector2i> passed_regions) {
        RouteToStitch rts = new RouteToStitch(this.electric_segments.get(seg_id));
        rts.coarse_route = route;
        rts.id = seg_id;
        rts.region_positions = passed_regions;
        this.output_coarse_routes.put(rts.id, rts);
    }

    public synchronized void AddRouteToOutReg(Vector2i reg_pos, SegPart segment) {
        RegionToRoute region = this.OutputRegionAt(reg_pos.x, reg_pos.y);
        region.segments_to_route.add(segment);
    }

    public RegionToRoute OutputRegionAt(int x, int y) {
        return this.output_regions[y * this.regions_x + x];
    }

    public RegionToRoute OutputRegionAt(int x, int y, RegionDirection dir) {
        switch (dir) {
            case rd_left: {
                --x;
                break;
            }
            case rd_right: {
                ++x;
                break;
            }
            case rd_down: {
                --y;
                break;
            }
            case rd_up: {
                ++y;
                break;
            }
        }
        if (this.IsCoordinateValid(x, y)) {
            return this.OutputRegionAt(x, y);
        }
        return null;
    }

    public RegionRepresentation RegionAt(int x, int y) {
        return this.regions[y * this.regions_x + x];
    }

    public RegionRepresentation RegionAt(int x, int y, RegionDirection dir) {
        switch (dir) {
            case rd_left: {
                --x;
                break;
            }
            case rd_right: {
                ++x;
                break;
            }
            case rd_down: {
                --y;
                break;
            }
            case rd_up: {
                ++y;
                break;
            }
        }
        if (this.IsCoordinateValid(x, y)) {
            return this.RegionAt(x, y);
        }
        return null;
    }

    public boolean IsCoordinateValid(int x, int y) {
        return 0 <= x && x < this.regions_x && 0 <= y && y < this.regions_y;
    }

    public int ConvertX(double x) {
        return (int)(x / this.region_width);
    }

    public int ConvertY(double y) {
        return (int)(y / this.region_height);
    }

    public RegionDirection DirFromTo(Vector2i from, Vector2i to) {
        int x = to.x - from.x;
        int y = to.y - from.y;
        RegionDirection dir = x == 1 && y == 0 ? RegionDirection.rd_right : (x == -1 && y == 0 ? RegionDirection.rd_left : (x == 0 && y == 1 ? RegionDirection.rd_up : (x == 0 && y == -1 ? RegionDirection.rd_down : RegionDirection.rd_undefined)));
        return dir;
    }

    public int GetNeighborX(int x, RegionDirection dir) {
        switch (dir) {
            case rd_left: {
                --x;
                break;
            }
            case rd_right: {
                ++x;
                break;
            }
        }
        return x;
    }

    public int GetNeighborY(int y, RegionDirection dir) {
        switch (dir) {
            case rd_down: {
                --y;
                break;
            }
            case rd_up: {
                ++y;
                break;
            }
        }
        return y;
    }

    public Vector2i GetNeighborPos(int x, int y, RegionDirection dir) {
        switch (dir) {
            case rd_left: {
                --x;
                break;
            }
            case rd_right: {
                ++x;
                break;
            }
            case rd_down: {
                --y;
                break;
            }
            case rd_up: {
                ++y;
                break;
            }
        }
        return new Vector2i(x, y);
    }

    public Vector2i GetNeighborPos(Vector2i curr_pos, RegionDirection dir) {
        return this.GetNeighborPos(curr_pos.x, curr_pos.y, dir);
    }

    public static RegionDirection GetOppositeDir(RegionDirection dir) {
        switch (dir) {
            case rd_left: {
                return RegionDirection.rd_right;
            }
            case rd_right: {
                return RegionDirection.rd_left;
            }
            case rd_down: {
                return RegionDirection.rd_up;
            }
            case rd_up: {
                return RegionDirection.rd_down;
            }
        }
        return RegionDirection.rd_undefined;
    }

    public synchronized JobMessage PollSegmentJob() {
        if (this.segment_jobs.isEmpty()) {
            return null;
        }
        JobMessage job = this.segment_jobs.get(0);
        this.segment_jobs.remove(0);
        return job;
    }

    public synchronized SegmentRepresentation PollDemandEstimationJob() {
        SegmentRepresentation ret = null;
        if (this.to_reroute.isEmpty()) {
            if (this.demand_seg_index < this.segments.length) {
                ret = this.segments[this.demand_seg_index];
                this.demand_seg_index = this.demand_seg_index + 1;
            }
        } else if (this.demand_seg_index < this.to_reroute.size()) {
            ret = this.segments[this.to_reroute.get(this.demand_seg_index)];
            this.demand_seg_index = this.demand_seg_index + 1;
        }
        return ret;
    }

    public synchronized int PollFailedId() {
        if (this.remove_failed_index < this.to_reroute.size()) {
            int ret = this.to_reroute.get(this.remove_failed_index);
            this.remove_failed_index = this.remove_failed_index + 1;
            return ret;
        }
        return -1;
    }

    public synchronized void ResetOutputRoutes() {
        this.output_coarse_routes = new HashMap();
    }

    public synchronized void OfferBacktrace(Vector<RegionDirection> bt, int seg_id) {
        SegBtPair pair = new SegBtPair();
        pair.backtrace = bt;
        pair.seg_id = seg_id;
        this.seg_backtraces.add(pair);
    }

    public synchronized SegBtPair PollBacktrace() {
        SegBtPair ret;
        if (this.seg_backtraces.isEmpty()) {
            ret = new SegBtPair();
            ret.seg_id = -1;
            ret.backtrace = null;
        } else {
            ret = this.seg_backtraces.get(0);
            this.seg_backtraces.remove(0);
        }
        return ret;
    }

    public synchronized void OfferUnrouted(ArrayList<Integer> list) {
        this.not_routed.addAll(list);
    }

    public synchronized RegionRepresentation PollNextRegionToSort() {
        RegionRepresentation ret = null;
        if (this.regions_in_work < this.regions_x * this.regions_y) {
            ret = this.regions[this.regions_in_work];
            this.regions_in_work = this.regions_in_work + 1;
        }
        return ret;
    }

    public void Retransform(List<RoutingFrameLeeMoore.Coordinate> list) {
        for (RoutingFrameLeeMoore.Coordinate co : list) {
            co.x += this.offset_x;
            co.y += this.offset_y;
        }
    }

    public GlobalRouterV3(Rectangle2D rect, int num_regions, List<RoutingFrame.RoutingSegment> segmentsToRoute, int num_threads, double tileSize) {
        int y;
        int x;
        int i;
        this.tileSize = tileSize;
        this.num_threads = num_threads;
        this.barrier = new CyclicBarrier(num_threads);
        double w = rect.getWidth() / (double)num_regions;
        double h = rect.getHeight() / (double)num_regions;
        int num_tiles_w_in_region = (int)Math.ceil(w / this.tileSize);
        int num_tiles_h_in_region = (int)Math.ceil(h / this.tileSize);
        this.region_width = (double)num_tiles_w_in_region * this.tileSize;
        this.region_height = (double)num_tiles_h_in_region * this.tileSize;
        this.regions_x = num_regions;
        this.regions_y = num_regions;
        this.offset_x = rect.getMinX() - Math.signum(rect.getMinX()) * Math.abs(rect.getMinX()) % 0.01;
        this.offset_y = rect.getMinY() - Math.signum(rect.getMinY()) * Math.abs(rect.getMinY()) % 0.01;
        this.regions = new RegionRepresentation[this.regions_x * this.regions_y];
        this.electric_segments = new ArrayList<RoutingFrame.RoutingSegment>(segmentsToRoute);
        this.segments = new SegmentRepresentation[segmentsToRoute.size()];
        Iterator<RoutingFrame.RoutingSegment> it = segmentsToRoute.iterator();
        for (i = 0; i < this.segments.length; ++i) {
            RoutingFrame.RoutingSegment r_seg = it.next();
            double start_x = r_seg.getStartEnd().getLocation().getX() - this.offset_x;
            double start_y = r_seg.getStartEnd().getLocation().getY() - this.offset_y;
            double end_x = r_seg.getFinishEnd().getLocation().getX() - this.offset_x;
            double end_y = r_seg.getFinishEnd().getLocation().getY() - this.offset_y;
            Vector2i i_start = new Vector2i((int)(start_x / this.region_width), (int)(start_y / this.region_height));
            Vector2i i_end = new Vector2i((int)(end_x / this.region_width), (int)(end_y / this.region_height));
            if (i_start.x < 0) {
                i_start.x = 0;
            }
            if (i_start.x >= this.regions_x) {
                i_start.x = this.regions_x - 1;
            }
            if (i_start.y < 0) {
                i_start.y = 0;
            }
            if (i_start.y >= this.regions_y) {
                i_start.y = this.regions_y - 1;
            }
            if (i_end.x < 0) {
                i_end.x = 0;
            }
            if (i_end.x >= this.regions_x) {
                i_end.x = this.regions_x - 1;
            }
            if (i_end.y < 0) {
                i_end.y = 0;
            }
            if (i_end.y >= this.regions_y) {
                i_end.y = this.regions_y - 1;
            }
            this.segments[i] = new SegmentRepresentation(i_start, i_end);
            this.segments[i].d_start_x = start_x;
            this.segments[i].d_start_y = start_y;
            this.segments[i].d_end_x = end_x;
            this.segments[i].d_end_y = end_y;
        }
        for (i = 0; i < this.regions_x * this.regions_y; ++i) {
            this.regions[i] = new RegionRepresentation(0.0, this.segments.length);
        }
        int supply_x = this.max_supply_horizontal = (int)(this.region_width / tileSize) - 1;
        int supply_y = this.max_supply_vertical = (int)(this.region_height / tileSize) - 1;
        for (x = 0; x < this.regions_x; ++x) {
            for (y = 0; y < this.regions_y; ++y) {
                if (x > 0) {
                    this.RegionAt((int)x, (int)y).left_border = new RegionBorder(0, supply_y, this.max_supply_vertical);
                }
                if (y <= 0) continue;
                this.RegionAt((int)x, (int)y).lower_border = new RegionBorder(0, supply_x, this.max_supply_horizontal);
            }
        }
        for (x = 0; x < this.regions_x; ++x) {
            for (y = 0; y < this.regions_y; ++y) {
                if (x < this.regions_x - 1) {
                    this.RegionAt((int)x, (int)y).right_border = this.RegionAt((int)x, (int)y, (RegionDirection)RegionDirection.rd_right).left_border;
                }
                if (y >= this.regions_y - 1) continue;
                this.RegionAt((int)x, (int)y).upper_border = this.RegionAt((int)x, (int)y, (RegionDirection)RegionDirection.rd_up).lower_border;
            }
        }
        this.to_reroute = new ArrayList();
        this.segment_jobs = new ArrayList();
        this.demand_seg_index = 0;
        this.regions_in_work = 0;
        this.not_routed = new ArrayList();
        this.remove_failed_index = 0;
        this.seg_backtraces = new ArrayList();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            JobMessage job = new JobMessage(i2, this.segments[i2].start, 0, 0.0, RegionDirection.rd_undefined);
            this.segment_jobs.add(job);
        }
        this.output_coarse_routes = new HashMap();
        this.output_regions = new RegionToRoute[this.regions_x * this.regions_y];
        for (x = 0; x < this.regions_x; ++x) {
            for (int y2 = 0; y2 < this.regions_y; ++y2) {
                Rectangle2D.Double rec = new Rectangle2D.Double();
                rec.setFrameFromDiagonal((double)x * this.region_width, (double)y2 * this.region_height, (double)(x + 1) * this.region_width, (double)(y2 + 1) * this.region_height);
                this.output_regions[y2 * this.regions_x + x] = new RegionToRoute(rec);
            }
        }
    }

    public void Reinitialize(List<Integer> failed_to_route) {
        int x;
        this.to_reroute = new ArrayList<Integer>(failed_to_route);
        if (this.max_detour < Math.max(this.regions_x, this.regions_y)) {
            this.max_detour += 2;
        }
        for (RouteToStitch rts : this.output_coarse_routes.values()) {
            if (failed_to_route.contains(rts.id)) continue;
            this.wiried_routes.add(rts.id);
        }
        this.to_reroute.addAll(this.not_routed);
        this.not_routed = new ArrayList();
        this.segment_jobs = new ArrayList();
        this.demand_seg_index = 0;
        this.regions_in_work = 0;
        this.remove_failed_index = 0;
        this.seg_backtraces = new ArrayList();
        for (int i = 0; i < this.to_reroute.size(); ++i) {
            int seg_id = this.to_reroute.get(i);
            JobMessage job = new JobMessage(seg_id, this.segments[seg_id].start, 0, 0.0, RegionDirection.rd_undefined);
            this.segment_jobs.add(job);
        }
        this.output_regions = new RegionToRoute[this.regions_x * this.regions_y];
        for (x = 0; x < this.regions_x; ++x) {
            for (int y = 0; y < this.regions_y; ++y) {
                Rectangle2D.Double rec = new Rectangle2D.Double();
                rec.setFrameFromDiagonal((double)x * this.region_width, (double)y * this.region_height, (double)(x + 1) * this.region_width, (double)(y + 1) * this.region_height);
                this.output_regions[y * this.regions_x + x] = new RegionToRoute(rec);
            }
        }
        for (x = 0; x < this.regions_x; ++x) {
            for (int y = 0; y < this.regions_y; ++y) {
                if (x > 0) {
                    this.RegionAt((int)x, (int)y).left_border.demand = 0;
                }
                if (y <= 0) continue;
                this.RegionAt((int)x, (int)y).lower_border.demand = 0;
            }
        }
    }

    public void StartGlobalRouting() {
        Thread[] slave_threads = new Thread[this.num_threads - 1];
        GlobalRouterThreadV3[] slaves = new GlobalRouterThreadV3[this.num_threads];
        for (int i = 0; i < this.num_threads - 1; ++i) {
            slaves[i] = new GlobalRouterThreadV3(this, i);
            slave_threads[i] = new Thread(slaves[i]);
            slave_threads[i].setName("GlobalRouterSlave_" + i);
            slave_threads[i].start();
        }
        slaves[this.num_threads - 1] = new GlobalRouterThreadV3(this, this.num_threads - 1);
        slaves[this.num_threads - 1].run();
    }

    public class RouteToStitch {
        public int id = -1;
        public List<SegPart> coarse_route = null;
        public ArrayList<Vector2i> region_positions;
        public RoutingFrame.RoutingSegment seg_head_tail = null;
        public int start_layer = Integer.MIN_VALUE;
        public int finish_layer = Integer.MIN_VALUE;

        public RouteToStitch(RoutingFrame.RoutingSegment routing_seg) {
            this.seg_head_tail = routing_seg;
            this.start_layer = routing_seg.getStartLayers().get(0).getMetalNumber();
            this.finish_layer = routing_seg.getFinishLayers().get(0).getMetalNumber();
        }

        public ArrayList<RegionToRoute> SelectPassedRegionsFrom(RegionToRoute[] all_regions) {
            ArrayList<RegionToRoute> ret = new ArrayList<RegionToRoute>();
            for (Vector2i pos : this.region_positions) {
                ret.add(all_regions[pos.y * GlobalRouterV3.this.regions_x + pos.x]);
            }
            return ret;
        }
    }

    public class RegionToRoute {
        Rectangle2D bounds;
        List<SegPart> segments_to_route;

        public RegionToRoute(Rectangle2D b) {
            this.bounds = b;
            this.segments_to_route = new ArrayList<SegPart>();
        }
    }

    class RegionRepresentation {
        public double weight;
        public SegmentInfo[] segment_infos;
        public RegionBorder left_border;
        public RegionBorder right_border;
        public RegionBorder lower_border;
        public RegionBorder upper_border;

        public RegionRepresentation(double weight, int num_segs) {
            this.weight = weight;
            this.segment_infos = new SegmentInfo[num_segs];
        }

        public double getCongestionWeight() {
            double congestion = 0.0;
            congestion = this.left_border != null && this.left_border.GetWeight() != Double.MAX_VALUE ? (congestion += this.left_border.GetWeight()) : (congestion += 10.0);
            congestion = this.right_border != null && this.right_border.GetWeight() != Double.MAX_VALUE ? (congestion += this.right_border.GetWeight()) : (congestion += 10.0);
            congestion = this.lower_border != null && this.lower_border.GetWeight() != Double.MAX_VALUE ? (congestion += this.lower_border.GetWeight()) : (congestion += 10.0);
            congestion = this.upper_border != null && this.upper_border.GetWeight() != Double.MAX_VALUE ? (congestion += this.upper_border.GetWeight()) : (congestion += 10.0);
            return congestion;
        }

        public RegionBorder GetRegionBorder(RegionDirection dir) {
            switch (dir) {
                case rd_left: {
                    return this.left_border;
                }
                case rd_right: {
                    return this.right_border;
                }
                case rd_down: {
                    return this.lower_border;
                }
                case rd_up: {
                    return this.upper_border;
                }
            }
            return null;
        }
    }

    class SegmentRepresentation {
        public Vector2i start;
        public Vector2i end;
        public double d_start_x;
        public double d_start_y;
        public double d_end_x;
        public double d_end_y;

        SegmentRepresentation(Vector2i start, Vector2i end) {
            this.start = new Vector2i(start.x, start.y);
            this.end = new Vector2i(end.x, end.y);
        }
    }

    class SegBtPair {
        public int seg_id;
        public Vector<RegionDirection> backtrace;

        SegBtPair() {
        }
    }

    class RegionBorder {
        private int demand;
        private int supply;
        private int min_supply = 4;
        private Vector<Integer> priv_soft_passes;
        private ArrayList<Integer> soft_passes = new ArrayList();
        private Vector<Integer> hard_passes = new Vector();

        public RegionBorder(int demand, int supply, int passes) {
            this.demand = demand;
            this.supply = supply;
            this.priv_soft_passes = new Vector();
            for (int i = 0; i < passes; ++i) {
                this.priv_soft_passes.add(null);
                this.hard_passes.add(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean IsBlocked() {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                return this.supply <= this.min_supply;
            }
        }

        public int GetDemand() {
            return this.demand;
        }

        public void IncDemand() {
            ++this.demand;
        }

        public boolean DecDemand() {
            if (this.demand > 0) {
                --this.demand;
                return true;
            }
            return false;
        }

        public int GetSupply() {
            return this.supply;
        }

        public int GetHardPos(int seg_id) {
            return this.hard_passes.indexOf(seg_id);
        }

        public double GetWeight() {
            double estd = (double)(this.demand + 1) / 16.0;
            double weight = Double.MAX_VALUE;
            if (estd <= (double)(this.supply - this.min_supply)) {
                weight = estd * 8.0 / Math.pow(2.0, ((double)this.supply - (double)this.min_supply - estd) / 2.0);
            } else if (estd > (double)(this.supply - this.min_supply) && this.supply - this.min_supply >= 3) {
                weight = estd * 8.0 * 2.0 / Math.pow(2.0, (double)this.supply - (double)(this.min_supply / 2));
            } else if (estd > (double)(this.supply - this.min_supply) && this.supply - this.min_supply == 2) {
                weight = estd * 8.0 * 3.0;
            } else if (estd > (double)(this.supply - this.min_supply) && this.supply - this.min_supply == 1) {
                weight = estd * 8.0 * 9.0;
            } else if (this.supply - this.min_supply == 0) {
                weight = Double.MAX_VALUE;
            }
            return weight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean SoftPassBorder(int seg_id) {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                if (this.supply > this.min_supply) {
                    --this.supply;
                    this.soft_passes.add(seg_id);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean FromSoftToPriv(int seg_id, int priv_pos) {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                if (this.soft_passes.contains(seg_id)) {
                    this.soft_passes.remove(this.soft_passes.indexOf(seg_id));
                    int delta = 1;
                    int length = this.priv_soft_passes.size();
                    int lower = priv_pos - delta;
                    int higher = priv_pos + delta;
                    while (lower >= 0 && lower < length || higher >= 0 && higher < length) {
                        if (lower >= 0 && lower < length && this.priv_soft_passes.get(lower) == null) {
                            this.priv_soft_passes.set(lower, seg_id);
                            return true;
                        }
                        if (higher >= 0 && higher < length && this.priv_soft_passes.get(higher) == null) {
                            this.priv_soft_passes.set(higher, seg_id);
                            return true;
                        }
                        lower = priv_pos - ++delta;
                        higher = priv_pos + delta;
                    }
                    this.soft_passes.add(seg_id);
                    return false;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean SoftPassBorder(int seg_id, int priv_pos) {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                if (this.supply > this.min_supply) {
                    --this.supply;
                    if (this.priv_soft_passes.get(priv_pos) == null) {
                        this.priv_soft_passes.set(priv_pos, seg_id);
                        return true;
                    }
                    int delta = 1;
                    int length = this.priv_soft_passes.size();
                    int lower = priv_pos - delta;
                    int higher = priv_pos + delta;
                    while (lower >= 0 && lower < length || higher >= 0 && higher < length) {
                        if (lower >= 0 && lower < length && this.priv_soft_passes.get(lower) == null) {
                            this.priv_soft_passes.set(lower, seg_id);
                            return true;
                        }
                        if (higher >= 0 && higher < length && this.priv_soft_passes.get(higher) == null) {
                            this.priv_soft_passes.set(higher, seg_id);
                            return true;
                        }
                        lower = priv_pos - ++delta;
                        higher = priv_pos + delta;
                    }
                    this.soft_passes.add(seg_id);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean RevertSoftPass(int seg_id) {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                if (this.soft_passes.contains(seg_id)) {
                    ++this.supply;
                    this.soft_passes.remove(this.soft_passes.indexOf(seg_id));
                    return true;
                }
                if (this.priv_soft_passes.contains(seg_id)) {
                    ++this.supply;
                    int index = this.priv_soft_passes.indexOf(seg_id);
                    this.priv_soft_passes.set(index, null);
                    return true;
                }
                return false;
            }
        }

        public Vector<Integer> HardPassBorderV2() {
            this.HardPassBorder();
            return new Vector<Integer>(this.hard_passes);
        }

        public Vector<Integer> HardPassBorderV2(Vector<Integer> passes) {
            for (int i = 0; i < passes.size(); ++i) {
                Integer id = passes.get(i);
                if (id == null || !this.soft_passes.contains(id)) continue;
                this.FromSoftToPriv(id, i);
            }
            this.HardPassBorder();
            return new Vector<Integer>(this.hard_passes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void HardPassBorder() {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                Collections.sort(this.soft_passes);
                block3: for (int priv_i = 0; priv_i < this.priv_soft_passes.size(); ++priv_i) {
                    if (this.priv_soft_passes.get(priv_i) == null) continue;
                    int id = this.priv_soft_passes.get(priv_i);
                    if (this.hard_passes.get(priv_i) == null) {
                        this.hard_passes.set(priv_i, id);
                        continue;
                    }
                    int delta = 1;
                    int length = this.hard_passes.size();
                    int lower = priv_i - delta;
                    int higher = priv_i + delta;
                    while (lower >= 0 && lower < length || higher >= 0 && higher < length) {
                        if (lower >= 0 && lower < length && this.hard_passes.get(lower) == null) {
                            this.hard_passes.set(lower, id);
                            continue block3;
                        }
                        if (higher >= 0 && higher < length && this.hard_passes.get(higher) == null) {
                            this.hard_passes.set(higher, id);
                            continue block3;
                        }
                        lower = priv_i - ++delta;
                        higher = priv_i + delta;
                    }
                }
                int hi = this.min_supply / 2;
                for (int si = 0; si < this.soft_passes.size(); ++si) {
                    while (hi < this.hard_passes.size() && this.hard_passes.get(hi) != null && this.hard_passes.get(hi) >= 0) {
                        ++hi;
                    }
                    if (hi < this.hard_passes.size()) {
                        this.hard_passes.set(hi, this.soft_passes.get(si));
                    } else {
                        this.hard_passes.add(this.soft_passes.get(si));
                    }
                    ++hi;
                }
                this.soft_passes = new ArrayList();
                int passes = this.priv_soft_passes.size();
                this.priv_soft_passes = new Vector();
                for (int i = 0; i < passes; ++i) {
                    this.priv_soft_passes.add(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean RevertHardPass(int seg_id) {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                int index = this.hard_passes.indexOf(seg_id);
                if (index >= 0) {
                    ++this.supply;
                    this.hard_passes.set(index, null);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void CleanBorder() {
            RegionBorder regionBorder = this;
            synchronized (regionBorder) {
                for (Integer i : GlobalRouterV3.this.not_routed) {
                    if (this.soft_passes.contains(i)) {
                        this.soft_passes.remove(this.soft_passes.indexOf(i));
                    }
                    if (!this.priv_soft_passes.contains(i)) continue;
                    this.priv_soft_passes.set(this.priv_soft_passes.indexOf(i), null);
                }
            }
        }
    }

    class SegmentInfo {
        public boolean is_initialized = false;
        public boolean was_part_of_bt = false;
        public boolean is_on_min_path = false;
        private ArrayList<WeightLengthPair> left_back_scores = new ArrayList();
        private ArrayList<WeightLengthPair> right_back_scores = new ArrayList();
        private ArrayList<WeightLengthPair> up_back_scores = new ArrayList();
        private ArrayList<WeightLengthPair> down_back_scores = new ArrayList();

        SegmentInfo() {
        }

        public ArrayList<WeightLengthPair> GetScores(RegionDirection dir) {
            ArrayList<WeightLengthPair> ret = null;
            switch (dir) {
                case rd_left: {
                    ret = this.left_back_scores;
                    break;
                }
                case rd_right: {
                    ret = this.right_back_scores;
                    break;
                }
                case rd_up: {
                    ret = this.up_back_scores;
                    break;
                }
                case rd_down: {
                    ret = this.down_back_scores;
                    break;
                }
                case rd_undefined: {
                    ret = null;
                }
            }
            return ret;
        }

        public boolean RefreshSegment(int length, double weight, RegionDirection min_dir) {
            if (GlobalRouterV3.this.max_detour < length) {
                return false;
            }
            if (!this.is_initialized) {
                this.is_initialized = true;
            }
            if (min_dir != RegionDirection.rd_undefined) {
                ArrayList<WeightLengthPair> scores = this.GetScores(min_dir);
                for (WeightLengthPair wlp : scores) {
                    if (wlp.length > length || !(wlp.weight <= weight)) continue;
                    return false;
                }
                this.GetScores(min_dir).add(new WeightLengthPair(weight, length));
            } else {
                for (RegionDirection dir : RegionDirection.values()) {
                    if (dir == RegionDirection.rd_undefined) continue;
                    ArrayList<WeightLengthPair> scores = this.GetScores(dir);
                    scores.add(new WeightLengthPair(weight, length));
                }
            }
            return true;
        }

        public BacktraceState GetMin(int max_path_length) {
            if (!this.is_initialized) {
                return null;
            }
            BacktraceState min = null;
            for (RegionDirection dir : RegionDirection.values()) {
                if (dir == RegionDirection.rd_undefined) continue;
                ArrayList<WeightLengthPair> scores = this.GetScores(dir);
                for (WeightLengthPair cur_wlp : scores) {
                    if (cur_wlp.length > max_path_length) continue;
                    if (min == null) {
                        min = new BacktraceState(cur_wlp.weight, dir, cur_wlp.length);
                        continue;
                    }
                    if (!(cur_wlp.weight < min.weight)) continue;
                    min.weight = cur_wlp.weight;
                    min.dir = dir;
                    min.path_length = cur_wlp.length;
                }
            }
            return min;
        }
    }
}

