/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include        <gle/gleconfig.h>


#include	"gleproxy.h"
#include	"glegtoplevel.h"


/* --- functions --- */
GtkType
gle_proxy_for_gtktype (GtkType gtk_type)
{
  if (gtk_type_is_a (gtk_type, GTK_TYPE_WINDOW))
    return GLE_TYPE_GTOPLEVEL;
  if (gtk_type_is_a (gtk_type, GTK_TYPE_CONTAINER))
    return GLE_TYPE_GCONTAINER;
  if (gtk_type_is_a (gtk_type, GTK_TYPE_WIDGET))
    return GLE_TYPE_GWIDGET;
  if (gtk_type_is_a (gtk_type, GTK_TYPE_OBJECT))
    return GLE_TYPE_GOBJECT;

  return 0;
}
