/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	<gle/gleconfig.h>

#include	"glegtoplevel.h"
#include	"gleprivate.h"
#include	"gleproxy.h"



/* --- prototypes --- */
static void  gle_gtoplevel_class_init		(GleGToplevelClass*class);
static void  gle_gtoplevel_init			(GleGToplevel	*gtoplevel);
static void  gle_gtoplevel_do_initialize	(GleGObject	*gobject);
static void  gle_gtoplevel_do_pre_destroy	(GleGObject	*gobject);
static void  gle_gtoplevel_do_post_instantiate	(GleGToplevel	*gtoplevel);


/* --- variables --- */
static GleGContainerClass	*parent_class = NULL;
static GList			*gle_toplevels = NULL;
static GHookList		 init_hooks = { 0 };


/* --- functions --- */
static void
gle_gtoplevel_hook_marshaller (GHook          *hook,
			       gpointer        data)
{
  GleGToplevelHookFunc func = hook->func;

  func (data, hook->data);
}

GtkType
gle_gtoplevel_get_type (void)
{
  static GtkType gtoplevel_type = 0;
  
  if (!gtoplevel_type)
    {
      GtkTypeInfo gtoplevel_info =
      {
	"GleGToplevel",
	sizeof (GleGToplevel),
	sizeof (GleGToplevelClass),
	(GtkClassInitFunc) gle_gtoplevel_class_init,
	(GtkObjectInitFunc) gle_gtoplevel_init,
	/* reserved_1 */ NULL,
	/* reserved_2 */ NULL,
	(GtkClassInitFunc) NULL,
      };
      
      gtoplevel_type = gtk_type_unique (GLE_TYPE_GCONTAINER, &gtoplevel_info);
      gtk_type_set_chunk_alloc (gtoplevel_type, GLE_GTOPLEVELS_PREALLOC);
    }
  
  return gtoplevel_type;
}

static void
gle_gtoplevel_class_init (GleGToplevelClass *class)
{
  GleGObjectClass *gobject_class;
  GleGWidgetClass *gwidget_class;
  GleGContainerClass *gcontainer_class;
  
  parent_class = gtk_type_class (GLE_TYPE_GCONTAINER);
  gobject_class = (GleGObjectClass*) class;
  gwidget_class = (GleGWidgetClass*) class;
  gcontainer_class = (GleGContainerClass*) class;
  
  gobject_class->initialize = gle_gtoplevel_do_initialize;
  gobject_class->pre_destroy = gle_gtoplevel_do_pre_destroy;

  class->post_instantiate = gle_gtoplevel_do_post_instantiate;

  GLE_CLASS_ADD_NOTIFY_METHOD (class, GleGToplevelClass, post_instantiate);
}

static void
gle_gtoplevel_init (GleGToplevel *gtoplevel)
{
}

static void
gle_gtoplevel_do_initialize (GleGObject *gobject)
{
  GleGToplevel	 *gtoplevel;
  
  gtoplevel = GLE_GTOPLEVEL (gobject);
  
  GLE_GOBJECT_CLASS (parent_class)->initialize (gobject);
  
  gle_toplevels = g_list_prepend (gle_toplevels, gtoplevel);

  if (init_hooks.seq_id)
    g_hook_list_marshal (&init_hooks, TRUE, gle_gtoplevel_hook_marshaller, gtoplevel);
}

void
gle_gtoplevel_do_pre_destroy (GleGObject *gobject)
{
  GleGToplevel *gtoplevel;
  
  gtoplevel = GLE_GTOPLEVEL (gobject);
  
  /* if (init_hooks.seq_id) */
  /*   g_hook_list_marshal (&destroy_hooks, TRUE, gle_gtoplevel_hook_marshaller, gtoplevel); */

  gle_toplevels = g_list_remove (gle_toplevels, gtoplevel);
  
  GLE_GOBJECT_CLASS (parent_class)->pre_destroy (gobject);
}

GleGWidget*
gle_toplevel_make_gwidget (GtkWidget *widget)
{
  GleGWidget *gwidget;
  
  g_return_val_if_fail (widget != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (widget), NULL);
  g_return_val_if_fail (!GTK_OBJECT_DESTROYED (widget), NULL);
  g_return_val_if_fail (GTK_WIDGET_TOPLEVEL (widget), NULL);
  g_return_val_if_fail (!GLE_HAS_TAG (widget), NULL);
  
  if (!gtk_type_is_a (gle_proxy_for_gtktype (GTK_OBJECT_TYPE (widget)), GLE_TYPE_GTOPLEVEL))
    {
      g_warning ("failed to retrive correct proxy type for Gtk+ toplevel \"%s\"",
		 gtk_type_name (GTK_OBJECT_TYPE (widget)));
      return NULL;
    }
  
  gwidget = gle_widget_force_gwidget (widget);
  gle_gcontainer_force_gchildren (GLE_GCONTAINER (gwidget));
  
  return gwidget;
}

GList*
gle_gtoplevel_get_list (void)
{
  return gle_toplevels;
}

guint
gle_gtoplevel_add_init_hook (GleGToplevelHookFunc func,
			     gpointer             data)
{
  GHook *hook;

  g_return_val_if_fail (func != NULL, 0);

  if (!init_hooks.seq_id)
    g_hook_list_init (&init_hooks, sizeof (GHook));

  hook = g_hook_alloc (&init_hooks);
  hook->func = func;
  hook->data = data;
  hook->destroy = NULL;

  g_hook_prepend (&init_hooks, hook);

  return hook->hook_id;
}

void
gle_gtoplevel_remove_init_hook (guint hook_id)
{
  g_return_if_fail (hook_id > 0);

  if (!g_hook_destroy (&init_hooks, hook_id))
    g_warning ("gle_gtoplevel_remove_init_hook(%u): no such hook", hook_id);
}

void
gle_gtoplevel_disassociate (GleGToplevel *gtoplevel)
{
  g_return_if_fail (gtoplevel != NULL);
  g_return_if_fail (GLE_IS_GTOPLEVEL (gtoplevel));
  g_return_if_fail (GLE_GOBJECT_IS_INSTANTIATED (gtoplevel));

  /* this functions acts recursively through the gcontainer method */

  gle_gobject_disassociate (GLE_GOBJECT (gtoplevel));
}

static void
gle_tree_apply_args (GleGWidget *gwidget,
		     gint        what)
{
  switch (what)
    {
    case 0:
      gle_gobject_apply_all_args (GLE_GOBJECT (gwidget));
      break;
    case 1:
      gle_gobject_apply_object_args (GLE_GOBJECT (gwidget));
      break;
    case 2:
      gle_gwidget_apply_child_args (gwidget);
      break;
    }

  if (GLE_IS_GCONTAINER (gwidget))
    {
      GleGContainer *gcontainer;
      GList *list;

      gcontainer = GLE_GCONTAINER (gwidget);
      
      for (list = gcontainer->children; list; list = list->next)
	{
	  GleGWidget *gchild;
	  
	  gchild = list->data;
	  if (GLE_GOBJECT_IS_INSTANTIATED (gchild))
	    gle_tree_apply_args (gchild, what);
	}
    }
}

static void
gle_tree_instantiate (GleGWidget *gwidget,
		      GleGWidget *gtoplevel)
{
  if (!GLE_GOBJECT_IS_INSTANTIATED (gwidget))
    gle_gobject_instantiate (GLE_GOBJECT (gwidget));

  if (GLE_IS_GCONTAINER (gwidget))
    {
      GleGContainer *gcontainer;
      GList *list;

      gcontainer = GLE_GCONTAINER (gwidget);
      for (list = gcontainer->children; list; list = list->next)
	{
	  GleGWidget *gchild;
	  
	  gchild = list->data;
	  if (!GLE_GOBJECT_IS_INSTANTIATED (gchild))
	    gle_tree_instantiate (gchild, gtoplevel);
	}
    }
}

void
gle_gtoplevel_instantiate (GleGToplevel *gtoplevel)
{
  GleGArg *garg;
  gboolean was_visible;
  GleGWidget *gwidget;
  GleGContainer *gcontainer;
  
  g_return_if_fail (gtoplevel != NULL);
  g_return_if_fail (GLE_IS_GTOPLEVEL (gtoplevel));
  g_return_if_fail (!GLE_GOBJECT_IS_INSTANTIATED (gtoplevel));
  g_return_if_fail (GLE_GWIDGET (gtoplevel)->parent == NULL);

  gwidget = GLE_GWIDGET (gtoplevel);
  gcontainer = GLE_GCONTAINER (gwidget);
  
  garg = gle_gobject_get_object_garg (GLE_GOBJECT (gtoplevel), "GtkWidget::visible");
  was_visible = GTK_VALUE_BOOL (garg->object_arg);
  GTK_VALUE_BOOL (garg->object_arg) = FALSE;
  
  gle_gwidget_ref (gwidget);
  
  /* 1. instantiate container
   * 2. instantiate children recursively (adds to parent)
   * 3. apply children's object arguments recursively
   * 4. apply children's child arguments recursively
   * 5. apply all arguments recursively
   * 6. show container if desired
   */
  
  gle_gobject_instantiate (GLE_GOBJECT (gwidget));
  gle_tree_instantiate (gwidget, gwidget);
  
  gle_tree_apply_args (gwidget, 1);

  gle_tree_apply_args (gwidget, 0);
  
  GTK_VALUE_BOOL (garg->object_arg) = was_visible;

  GLE_GOBJECT_NOTIFY (gtoplevel, post_instantiate, NULL, NULL);

  GLE_GTOPLEVEL_GET_CLASS (gtoplevel)->post_instantiate (gtoplevel);
  
  gle_gwidget_unref (gwidget);
}

static void
gle_gtoplevel_do_post_instantiate (GleGToplevel	*gtoplevel)
{
  GleGArg *garg;

  garg = gle_gobject_get_object_garg (GLE_GOBJECT (gtoplevel), "GtkWidget::visible");
  if (GTK_VALUE_BOOL (garg->object_arg))
    gtk_widget_show (GLE_GWIDGET_WIDGET (gtoplevel));
  else
    gtk_widget_hide (GLE_GWIDGET_WIDGET (gtoplevel));
}
