/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLEPUBLIC_H__
#define __GLEPUBLIC_H__


#include	<gle/glemisc.h>
#include	<gle/gleproxy.h>
#include	<gle/glegarg.h>
#include	<gle/glegobject.h>
#include	<gle/glegwidget.h>
#include	<gle/glegcontainer.h>
#include	<gle/glegtoplevel.h>
#include	<gle/gleselector.h>
#include	<gle/glerc.h>
#include	<gle/glercpref.h>
#include	<gle/glestock.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- GLE typedefs --- */
typedef void (*GleHookFunc)		(gpointer data);


/* --- GLE version variables --- */
extern  const guint     gle_version_major;
extern  const guint     gle_version_revision;
extern  const guint     gle_version_patchlevel;
extern  const guint     gle_version_age;
extern  const gchar     *gle_version;


/* --- GLE main part --- */
void            gle_init                        (int            *argc,
						 char           ***argv);
const gchar*    gle_get_prgname                 (void);
void            gle_finish                      (void);


/* --- GtkObject functions --- */
gchar*		gle_object_get_gname		(GtkObject	*object);


/* --- GLE builder functions --- */
void		gle_build_from_file_by_name	(const gchar	*file_name);
void		gle_build_from_file		(gint		 input_fd);
void		gle_build_from_text		(const gchar	*text,
						 guint		 text_len);
void		gle_build_plain_window		(const gchar	*gname);




#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLEPUBLIC_H__ */
