/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEPUBLIC_H__
#define __GLEPUBLIC_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- GtkObject functions --- */
const gchar*	gle_object_get_gle_name		(GtkObject	*object);
void		gle_object_set_gle_name		(GtkObject	*object,
						 const gchar	*gle_name);
GtkObject*	gle_object_lookup		(const gchar	*gle_name);

/* --- GLE tools --- */
GtkWidget*	gle_popup_gle_shell		(void);
GtkWidget*	gle_popup_gle_shell_customer	(GtkWidget	*customer);
GtkWidget*	gle_popup_gle_shell_selector	(void);
GtkWidget*	gle_popup_widget_editor		(GtkWidget	*widget);


/* --- GLE builder functions --- */
void		gle_build_from_file_by_name	(const gchar	*file_name);
void		gle_build_from_file		(gint		 input_fd);
void		gle_build_from_text		(const gchar	*text,
						 guint		 text_len);
void		gle_build_plain_window		(const gchar	*gle_name);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEPUBLIC_H__ */
