/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEMEM_H__
#define __GLEMEM_H__


#include	"glegarg.h"
#include	"glegobject.h"
#include	"glegwidget.h"
#include	<string.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- helper macros --- */
#define	_GLE_CHUNK_BLOCK(t)	(_gle_extern_mem_chunk_ ## t ## _block)
#define	_GLE_CHUNK_DECL(t)	extern GMemChunk*_GLE_CHUNK_BLOCK(t);
#define	_GLE_CHUNK_ALLOC(t)	(g_mem_chunk_alloc(_GLE_CHUNK_BLOCK(t)))
#define	_GLE_CHUNK_ALLOC_0(t)	((t*)memset(_GLE_CHUNK_ALLOC(t),0,sizeof(t)))
#define	_GLE_CHUNK_ALLOC_1(t)	((t*)_GLE_CHUNK_ALLOC(t))
#define	_GLE_CHUNK_FREE(t,m)	(g_mem_chunk_free(_GLE_CHUNK_BLOCK(t),(gpointer)m))


/* --- mem chunk declarations --- */
_GLE_CHUNK_DECL (GleGArg);
_GLE_CHUNK_DECL (GleArgInfo);
_GLE_CHUNK_DECL (GleGObject);
_GLE_CHUNK_DECL (GleGWidget);


/* --- internal prototypes --- */
void	_gle_mem_chunks_init		(void);
void	_gle_mem_chunks_destroy		(void);


/* --- allocators --- */
#define	gle_garg_chunk_new()		(_GLE_CHUNK_ALLOC_1 (GleGArg))
#define	gle_garg_chunk_new0()		(_GLE_CHUNK_ALLOC_0 (GleGArg))
#define	gle_arg_info_chunk_new()	(_GLE_CHUNK_ALLOC_1 (GleArgInfo))
#define	gle_arg_info_chunk_new0()	(_GLE_CHUNK_ALLOC_0 (GleArgInfo))
#define	gle_gobject_chunk_new()		(_GLE_CHUNK_ALLOC_1 (GleGObject))
#define	gle_gobject_chunk_new0()	(_GLE_CHUNK_ALLOC_0 (GleGObject))
#define	gle_gwidget_chunk_new()		(_GLE_CHUNK_ALLOC_1 (GleGWidget))
#define	gle_gwidget_chunk_new0()	(_GLE_CHUNK_ALLOC_0 (GleGWidget))


/* --- deallocators --- */
#define	gle_garg_chunk_free(m)		(_GLE_CHUNK_FREE (GleGArg, m))
#define	gle_arg_info_chunk_free(m)	(_GLE_CHUNK_FREE (GleArgInfo, m))
#define	gle_gobject_chunk_free(m)	(_GLE_CHUNK_FREE (GleGObject, m))
#define	gle_gwidget_chunk_free(m)	(_GLE_CHUNK_FREE (GleGWidget, m))




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEMEM_H__ */
