/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glelinkage.h"


/* --- prototypes --- */


/* --- variables --- */


/* --- functions --- */
GtkType
gtk_widget_query_child_slot (GtkWidget      *widget)
{
  const GtkType no_slot = GTK_TYPE_NONE;
  
  g_return_val_if_fail (widget != NULL, no_slot);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), no_slot);
  
  if (!GTK_IS_CONTAINER (widget))
    return no_slot;

  /* this function needs to be kept up to date with Gtk+'
   * current widget tree, it is known to work for the following:
   *
   * GtkObject
   *  +GtkData
   *  | +GtkAdjustment
   *  | `GtkTooltips
   *  `GtkWidget
   *    +GtkContainer
   *    | +GtkBin
   *    | | +GtkAlignment
   *    | | +GtkEventBox
   *    | | +GtkFrame
   *    | | | `GtkAspectFrame
   *    | | +GtkHandleBox
   *    | | +GtkItem
   *    | | | +GtkListItem
   *    | | | +GtkMenuItem
   *    | | | | `GtkCheckMenuItem
   *    | | | |   `GtkRadioMenuItem
   *    | | | `GtkTreeItem
   *    | | +GtkViewport
   *    | | `GtkWindow
   *    | |   +GtkColorSelectionDialog
   *    | |   +GtkDialog
   *    | |   | `GtkInputDialog
   *    | |   `GtkFileSelection
   *    | +GtkBox
   *    | | +GtkButtonBox
   *    | | | +GtkHButtonBox
   *    | | | `GtkVButtonBox
   *    | | +GtkHBox
   *    | | | +GtkCombo
   *    | | | `GtkStatusbar
   *    | | `GtkVBox
   *    | |   +GtkColorSelection
   *    | |   `GtkGammaCurve
   *    | +GtkButton
   *    | | +GtkOptionMenu
   *    | | `GtkToggleButton
   *    | |   `GtkCheckButton
   *    | |     `GtkRadioButton
   *    | +GtkCList
   *    | +GtkFixed
   *    | +GtkList
   *    | +GtkMenuShell
   *    | | +GtkMenuBar
   *    | | `GtkMenu
   *    | +GtkNotebook
   *    | +GtkPaned
   *    | | +GtkHPaned
   *    | | `GtkVPaned
   *    | +GtkScrolledWindow
   *    | +GtkTable
   *    | +GtkToolbar
   *    | `GtkTree
   *    +GtkDrawingArea
   *    | `GtkCurve
   *    +GtkEntry
   *    +GtkMisc
   *    | +GtkArrow
   *    | +GtkImage
   *    | +GtkLabel
   *    | | `GtkTipsQuery
   *    | `GtkPixmap
   *    +GtkPreview
   *    +GtkProgressBar
   *    +GtkRange
   *    | +GtkScale
   *    | | +GtkHScale
   *    | | `GtkVScale
   *    | `GtkScrollbar
   *    |   +GtkHScrollbar
   *    |   `GtkVScrollbar
   *    +GtkRuler
   *    | +GtkHRuler
   *    | `GtkVRuler
   *    +GtkSeparator
   *    | +GtkHSeparator
   *    | `GtkVSeparator
   *    `GtkText
   */
  
  if (GTK_IS_BIN (widget))
    {
      GtkBin *bin;
      
      bin = GTK_BIN (widget);
      
      if (GTK_IS_WINDOW (widget))
	{
	  if (GTK_OBJECT_TYPE (widget) != gtk_window_get_type ())
	    {
	      /* we are talking about composite widgets here... */
	      
	      return no_slot;
	    }
	}
      
      return bin->child ? no_slot : GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_BOX (widget))
    {
      GtkBox *box;
      
      box = GTK_BOX (widget);
      
      return GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_BUTTON (widget))
    {
      GtkButton *button;
      
      button = GTK_BUTTON (widget);
      
      return button->child ? no_slot : GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_CLIST (widget))
    {
      GtkCList *clist;
      
      clist = GTK_CLIST (widget);
      
      return no_slot;
    }
  else if (GTK_IS_FIXED (widget))
    {
      GtkFixed *fixed;
      
      fixed = GTK_FIXED (widget);
      
      return GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_LIST (widget))
    {
      GtkList *list;
      
      list = GTK_LIST (widget);
      
      return gtk_list_item_get_type ();
    }
  else if (GTK_IS_MENU_SHELL (widget))
    {
      GtkMenuShell *menu_shell;
      
      menu_shell = GTK_MENU_SHELL (widget);
      
      return gtk_menu_item_get_type ();
    }
  else if (GTK_IS_NOTEBOOK (widget))
    {
      GtkNotebook *notebook;
      
      notebook = GTK_NOTEBOOK (widget);
      
      return GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_PANED (widget))
    {
      GtkPaned *paned;
      
      paned = GTK_PANED (widget);
      
      return !paned->child1 || !paned->child2 ? GTK_TYPE_WIDGET : no_slot;
    }
  else if (GTK_IS_SCROLLED_WINDOW (widget))
    {
      GtkScrolledWindow *scrolled_window;
      
      scrolled_window = GTK_SCROLLED_WINDOW (widget);
      
      return gtk_widget_query_child_slot (GTK_WIDGET (scrolled_window->viewport));
    }
  else if (GTK_IS_TABLE (widget))
    {
      GtkTable *table;
      
      table = GTK_TABLE (widget);
      
      return GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_TOOLBAR (widget))
    {
      GtkToolbar *toolbar;
      
      toolbar = GTK_TOOLBAR (widget);
      
      return GTK_TYPE_WIDGET;
    }
  else if (GTK_IS_TREE (widget))
    {
      GtkTree *tree;
      
      tree = GTK_TREE (widget);
      
      return gtk_tree_item_get_type ();
    }
  else
    return no_slot;
}
