/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEGWIDGET_H__
#define __GLEGWIDGET_H__


#include	"glegobject.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- typedefs --- */
typedef struct	_GleLayoutData	GleLayoutData;


/* --- structures --- */
struct _GleLayoutData
{
  GtkObject	*object;
};


gchar*		gle_widget_create_glename	(GtkWidget	*widget);
void		gle_widget_set_glename		(GtkWidget	*widget,
						 const gchar	*glename);
const gchar*	gle_widget_get_glename		(GtkWidget	*widget);

GleLayoutData*  gle_layout_new                  (const gchar    *glename);
void            gle_layout_destroy              (GleLayoutData  *layout);
void            gle_layout_associate            (GleLayoutData  *layout,
						 GtkWidget      *widget);
void            gle_layout_disassociate         (GleLayoutData  *layout);
GleLayoutData*  gle_widget_get_layout           (GtkWidget      *widget);
void            gle_layout_apply_to_widget      (GleLayoutData  *layout);
void            gle_layout_update_from_widget   (GleLayoutData  *layout);
void            gle_layout_reset                (GleLayoutData  *layout);
GleLayoutData*  gle_layout_lookup               (const gchar    *glename);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEGWIDGET_H__ */
