/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEGOBJECT_H__
#define __GLEGOBJECT_H__


#include	"glepublic.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- type macros --- */
#define	GLE_HAS_GLENAME(widget)	 (gle_object_get_glename (GTK_OBJECT (object)) != NULL)
#define	GLE_GOBJECT(gobj)	 ((GleGObject*)(gobj))
#define	GLE_IS_GOBJECT(gobj)	 (GTK_CHECK_TYPE (GLE_GOBJECT (gobj)->type, gtk_object_get_type ()))
#define	GLE_GOBJECT_EXISTS(gobj) (GLE_GOBJECT (gobj)->object != NULL)
#define	GLE_GET_GOBJECT(object)	 (gtk_object_get_user_data (GTK_OBJECT (object), gle_key_gobject))


/* --- typedefs --- */
typedef struct	_GleGObject	GleGObject;


/* --- structures --- */
struct _GleGObject
{
  GtkType	type;
  GtkObject	*object;
  gchar		*gle_name;

  GList		*gargs		/* of type GleGArg* */;
  GList		*connections	/* of type GleGHandler* */;
};


GleGObject*	gle_gobject_new			(const gchar	*gle_name,
						 GtkType	 type);
GtkObject*	gle_gobject_instantiate		(GleGObject	*gobject);
void		gle_gobject_set_arg		(GleGObject	*gobject,
						 GtkArg		*arg);
GleGObject*	gle_gobject_lookup		(const gchar	*gle_name);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEGOBJECT_H__ */
