/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEARGS_H__
#define __GLEARGS_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define	GLE_IS_GARG(garg)	(gtk_type_is_a (((GleGArg*)(garg))->widget_type, gtk_widget_get_type ()) && ((GleGArg*)(garg))->arg_name)



/* --- typedefs --- */
typedef	struct _GleGArg	GleGArg;
struct _GleGArg
{
  GtkType	 widget_type;
  const gchar	*arg_name;
  const GtkArg	*default_arg;
  GtkArg	 saved_arg;
  GtkArg	 widget_arg;
};


/* --- prototypes --- */
GleGArg*	gle_garg_new		(const GtkArg	*dfl_arg);
void		gle_garg_init		(GleGArg	*garg,
					 GtkWidget	*widget);
void		gle_garg_reset		(GleGArg	*garg);
void		gle_garg_free		(GleGArg*	 garg);

void		gle_arg_reset		(GtkArg		*arg);
const GtkArg*	gle_arg_get_default	(const gchar	*arg_name);
void		gle_arg_set_from_string (GtkArg		*arg,
					 const gchar	*value_string);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEARGS_H__ */
