#ifndef __GTHREAD_H__
#define __GTHREAD_H__
#define _REENTRANT 

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern const char      *g_log_domain_gthread;
#include <glib.h>

/* thread starting function */
typedef void            (*GThreadFunc)            (gpointer);

typedef struct _GThread       GThread;

struct _GThread
{
};

typedef struct _GThreadPrivate      GThreadPrivate;

struct _GThreadPrivate
{
};

/* create a new thread and start it with the function thread_func,
which gets the argument arg. stack_size determines the stack for the
process, if zero the default stack size is taken. */ 
GThread* g_thread_new(GThreadFunc thread_func, 
		      gpointer arg, 
		      guint stack_size);

/* the calling thread is blocked until thread is completed, returns
   FALSE, if thread is invalid. */
gboolean g_thread_join(GThread* thread);

/* get a reference to the current thread */
GThread* g_thread_get_current();

/* wait for microseconds mu-secs, microseconds == 0 means yield */
void g_thread_sleep(gulong microseconds);

/* exit the current thread */
void g_thread_exit();

/* allocate a new slot for private data. it is associated with the
   returned id. all non-zero data registered by a thread will be
   handed over to destroy_func, whenever the data is set again or
   when the threads ends. */
GThreadPrivate* g_thread_private_new(GDestroyNotify destroy_func);

/* set the private data connected to the current thread and id */
void g_thread_private_set(GThreadPrivate* id, gpointer data);

/* get the private data connected to the current thread and id, if it is not
   set yet, NULL will be returned */
gpointer g_thread_private_get(GThreadPrivate* id);

/* free the slot for private thread data, that includes running the
   destroy-function for all non-zero instances */
void g_thread_private_free(GThreadPrivate* id);

typedef struct _GMonitor      GMonitor;

struct _GMonitor
{
};

/* create a new monitor. */
GMonitor* g_monitor_new();

/* get the monitor, that is related to resource. That way you don't
   have to create a mutex centrally, but simply use it on an agreed
   pointer, i.e. a address of an object */
GMonitor* g_monitor_new_for_resource(gpointer resource);

/* free a monitor */
void g_monitor_free(GMonitor* monitor);

/* enter the monitor, if the current thread already is in the monitor,
   then only the entry counter is incremented. otherwise the current thread
   is suspended till the monitor is left by the holding thread */
void g_monitor_enter(GMonitor* monitor);

/* decrement the entry counter. if zero, leave the monitor. returns
   FALSE, if the monitor is not held by current thread */
gboolean g_monitor_exit(GMonitor* monitor);

/* wait for at most microseconds mu-secs to be notified. the monitor,
   if entered, is exited for that time and reentered afterwards
   (keeping the original entry count). FALSE is returned, if the time
   has passed before the signal came. microseconds == 0 means infinite
   wait. */
gboolean g_monitor_wait(GMonitor* monitor, gulong microseconds);

/* notify ONE of the threads waiting for monitor */
void g_monitor_notify(GMonitor* monitor);

/* notify ALL of the threads waiting for monitor */
void g_monitor_notify_all(GMonitor* monitor);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTHREAD_H__ */
