/***************************************************************************

	TITLE:		ls_writetab.c
	
----------------------------------------------------------------------------

	FUNCTION:	Writes out time history data in ASCII tab-delimited
			format, which can thereafter be read by several 
			popular graphing packages.

----------------------------------------------------------------------------

	MODULE STATUS:	developmental

----------------------------------------------------------------------------

	GENEALOGY:	940510 E. B. Jackson

	WRITTEN BY:	EBJ
	
	CODED BY:	EBJ
	
	MAINTAINED BY:	EBJ

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	940510	Copied from ls_writemat.c			EBJ

	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_writetab.c,v 1.4 1995/04/07 01:44:34 bjax Exp $
$Log: ls_writetab.c,v $
 * Revision 1.4  1995/04/07  01:44:34  bjax
 * Added logic to avoid endless loop if wrapped and Tape->Last == Tape->Length.
 *
 * Revision 1.3  1995/03/03  01:57:51  bjax
 * Modified to use new def'n of Tape->Chan structure (includes symbol rec
 * defined in ls_sym.h)  EBJ
 *
 * Revision 1.2  1994/05/11  13:50:58  bjax
 * Added fix to skip over null channels.
 *
 * Revision 1.1  1994/05/10  11:56:39  bjax
 * Initial revision
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:
		matname - found in ls_writemat.c - maps C names to ascii

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#include <getopt.h>
#include <stdio.h>
#include <string.h>
#include "ls_types.h"
#include "ls_tape.h"
#include "ls_sim_control.h"


/*	=============
	 definitions
	=============	*/
#define MAX_STRING 255
#define	NIL_POINTER 0L


extern TAPE	*Tape;

extern char *matname( const char *inname, char *outname );
/* defined in ls_writemat.c */


			    /*---------------+
===========================>|  ls_writetab   |<===============================
			    +---------------*/
							
void ls_writetab( char *file_name)

{
	int 	wrapped = 1;
	int 	i, j, null_chans;
	FILE	*fp;
	char	namebuf[128];


/* Count the number of null channels */

    null_chans = 0;
    for (i = 0; i<Tape->Num_Chan; i++)
	if (Tape->Chan[i]->Symbol.Addr == NULL) null_chans++;

    if (Tape->Num_Chan - null_chans > 0)
      {
	fp = fopen(file_name, "w");
	
	i = Tape->First;
	
	if (Tape->First < Tape->Last) wrapped = 0;
	
/* Write header info */

	fprintf( fp, "Time" );
	for ( j = 0; j < Tape->Num_Chan; j++ )
	  if (Tape->Chan[j]->Symbol.Addr != NULL)
	    fprintf( fp, "\t%s", matname(Tape->Chan[j]->Symbol.Par_Name, namebuf) );
	fprintf( fp, "\n" );

/* Write data */
	
	while( wrapped || (i <= Tape->Last) )
	{
		
		fprintf( fp, "%f", Tape->T_Stamp[i] );
		
		for ( j = 0; j < Tape->Num_Chan; j++ )
		  if (Tape->Chan[j]->Symbol.Addr != NULL)
		    fprintf( fp, "\t%f", Tape->Chan[j]->Data[i] );
		
		fprintf( fp, "\n" );
	
		i = i + sim_control_.write_spacing;
		if ( i >= Tape->Length ) 
		    if ( wrapped )
			{
			    i = i - Tape->Length;
			    wrapped = 0;
			}
		    else
			{
			    i = Tape->Last+1;
			}
	}

	fclose( fp );
      }
}
