/***************************************************************************

	TITLE:	ls_writemat.c
	
----------------------------------------------------------------------------

	FUNCTION:	Writes out time history data in ASCII matrix form.
	                Can thereafter be read by several popular matrix 
			laboratory software packages.

----------------------------------------------------------------------------

	MODULE STATUS:	developmental

----------------------------------------------------------------------------

	GENEALOGY:	921230 Bruce Jackson (see mod history below)

	WRITTEN BY:	EBJ
	
	CODED BY:	EBJ
	
	MAINTAINED BY:	EBJ

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	920507	Converted from Trajectory Viewer		EBJ
	920806	Converted from ASC2_to_PO16; ported to IRIS	EBJ
	920810	Incorporated single file argument		EBJ
	921027  Modified and incorporated into LaRCSim code	EBJ
	921029	Copied from  ls_writeav.c and modded to write matrix.	EBJ
	930803	Modified to work with the Tape parameter names	EBJ
	931220	Cleaned up the timeslice vector access method	EBJ
	940111	Changed header files from ls_eom.h to ls_types.	EBJ
	940506	Corrected handling of wrapped tapes (I think).  EBJ
	940509	More fixes to wrapped tapes.. maybe this works..    EBJ
	940511	Added handling of null data channels and better
		mapping of variable names into matlab names	EBJ
	

	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_writemat.c,v 1.11 1995/04/07 01:44:34 bjax Exp $
$Log: ls_writemat.c,v $
 * Revision 1.11  1995/04/07  01:44:34  bjax
 * Added logic to avoid endless loop if wrapped and Tape->Last == Tape->Length.
 *
 * Revision 1.10  1995/03/03  01:58:42  bjax
 * Modified to use new def'n of Tape->Chan structure (includes symbol rec
 * defined in ls_sym.h) EBJ
 *
 * Revision 1.9  1994/05/11  13:50:04  bjax
 * Added correction to skip over null channels. Also map C
 * variable names into matlab names without structure prefixes.
 *
 * Revision 1.8  1994/05/10  11:56:20  bjax
 * Allow underscore in variable names.
 *
 * Revision 1.7  1994/05/09  21:19:49  bjax
 * Added support for wrapped tape buffers and output interpolation.
 *
 * Revision 1.6  1994/05/06  18:25:24  bjax
 * Corrected wrapping of tape (I think).
 *
 * Revision 1.5  1994/01/11  19:04:25  bjax
 * Changed header file from "
 * "ls_eom.h" to "ls_types.h".
 *
 * Revision 1.4  1993/12/20  16:50:21  bjax
 * Cleaned up the time slice access method.  EBJ
 *
 * Revision 1.3  1993/12/04  12:39:52  bjax
 * minor fixes.
 *
 * Revision 1.2  1993/08/03  19:18:02  bjax
 * Writemat now uses tape header information to write out matrix file.  EBJ
 *
 * Revision 1.1  1992/12/30  13:20:51  bjax
 * Initial revision
 *
 * Revision 1.3  93/12/31  10:34:11  bjax
 * Added $Log marker as well.
 * 

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#include <getopt.h>
#include <stdio.h>
#include <string.h>
#include "ls_types.h"
#include "ls_tape.h"
#include "ls_sim_control.h"


/*	=============
	 definitions
	=============	*/
#define MAX_STRING 255
#define	NIL_POINTER 0L


extern TAPE	*Tape;

char *matname( const char *inname, char *outname )

{
    /* delete non-alphanumeric characters */
    
    char * buf;
    
    buf = outname;
    while ( *inname )
    {
	if   ( ( (*inname >= 'A') && (*inname <= 'Z' ) )
	    || ( (*inname >= 'a') && (*inname <= 'z' ) )
	    || ( (*inname >= '0') && (*inname <= '9' ) ) 
	    || ( *inname == '_' ))
		*outname++ = *inname;
	if (*inname == '.') buf = outname; /* ignore structure names */
	inname++;
    }
    *outname = '\0';
    buf[15] = '\0'; 
    return buf;
    
}

			    /*---------------+
===========================>|  ls_writemat   |<===============================
			    +---------------*/
							
void ls_writemat( char *file_name)

{
	int 	wrapped = 1;
	int 	i, j, null_chans;
	FILE	*fp;
	char	namebuf[128];

/* Count the number of null channels */

    null_chans = 0;
    for (i = 0; i<Tape->Num_Chan; i++)
	if (Tape->Chan[i]->Symbol.Addr == NULL) null_chans++;

    if ( Tape->Num_Chan - null_chans > 0)
      {
	fp = fopen(file_name, "w");
	
	i = Tape->First;
	
	if (Tape->First < Tape->Last) wrapped = 0;
	
/* Write header info */

	fprintf(fp, "temp = [\n");	
	
	while( wrapped || (i <= Tape->Last) )
	{
		
		fprintf( fp, "%f", Tape->T_Stamp[i] );
		
		for ( j = 0; j < Tape->Num_Chan; j++ )
		  if (Tape->Chan[j]->Symbol.Addr != NULL)
		    fprintf( fp, "\t%f", Tape->Chan[j]->Data[i] );
		
		fprintf( fp, "\n" );
	
		i = i + sim_control_.write_spacing;
		if ( i >= Tape->Length ) 
		    if ( wrapped )
			{
			    i = i - Tape->Length;
			    wrapped = 0;
			}
		    else
			{
			    i = Tape->Last+1;
			}
	}

/* Write trailer info */

	fprintf( fp, "];\nt     = temp(:, 1);\n" );
	i = 2;
	for( j = 0; j < Tape->Num_Chan; j++ )
	  if (Tape->Chan[j]->Symbol.Addr != NULL)
	    fprintf( fp, "%s = temp(:, %d);\n", 
		     matname(Tape->Chan[j]->Symbol.Par_Name, namebuf), i++ );
	fprintf(fp, "clear temp\n");
	fclose( fp );
      }
}
