/***************************************************************************

	TITLE:		ls_writeasc1.c
	
----------------------------------------------------------------------------

	FUNCTION:	Writes out time history data GetData asc1 format.

----------------------------------------------------------------------------

	MODULE STATUS:	developmental

----------------------------------------------------------------------------

	GENEALOGY:	940510 Bruce Jackson

	WRITTEN BY:	EBJ
	
	CODED BY:	EBJ
	
	MAINTAINED BY:	EBJ

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	940510	Generated from ls_writemat.c			EBJ

	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_writeasc1.c,v 1.7 1995/04/07 01:44:34 bjax Exp $
$Log: ls_writeasc1.c,v $
 * Revision 1.7  1995/04/07  01:44:34  bjax
 * Added logic to avoid endless loop if wrapped and Tape->Last == Tape->Length.
 *
 * Revision 1.6  1995/03/03  01:55:53  bjax
 * Modified to use new def'n of Tape->Chan structure (includes symbol rec
 * defined in ls_sym.h). EBJ
 *
 * Revision 1.5  1994/05/11  13:27:01  bjax
 * Added check to avoid writing bad channels.
 *
 * Revision 1.4  1994/05/11  12:39:53  bjax
 * Changed format of time stamp to get better resolution.
 *
 * Revision 1.3  1994/05/11  11:57:35  bjax
 * Shortened variable names to 15 chars to avoid error in xp import;
 * also eliminated structure names (just use field names).
 *
 * Revision 1.2  1994/05/10  20:58:44  bjax
 * Forced variable names to be 16 chars or shorter.
 *
 * Revision 1.1  1994/05/10  20:10:39  bjax
 * Initial revision
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#include <getopt.h>
#include <stdio.h>
#include <string.h>
#include "ls_types.h"
#include "ls_tape.h"
#include "ls_sim_control.h"


/*	=============
	 definitions
	=============	*/
#define MAX_STRING 255
#define	NIL_POINTER 0L
#define NAMES_PER_LINE 5
#define PTS_PER_LINE 4

extern TAPE	*Tape;
extern char *progname;

char *GDname( const char *inname, char *outname )

{
    /* delete non-alphanumeric characters */
    
    char * buf;
    
    buf = outname;
    while ( *inname )
    {
	if   ( ( (*inname >= 'A') && (*inname <= 'Z' ) )
	    || ( (*inname >= 'a') && (*inname <= 'z' ) )
	    || ( (*inname >= '0') && (*inname <= '9' ) ) 
	    || ( *inname == '_' ))
		*outname++ = *inname;
	if (*inname == '.') buf = outname; /* ignore structure names */
	inname++;
    }
    *outname = '\0';
    buf[15] = '\0';
    return buf;
    
}

			    /*---------------+
===========================>|  ls_writeasc1  |<===============================
			    +---------------*/
							
void ls_writeasc1( char *file_name)

{
    int     wrapped = 1;
    long    names_written, pts_written;
    int     i, j, null_chans;
    FILE    *fp;
    char    namebuf[128];

/* Count the number of null channels */

    null_chans = 0;
    for (i = 0; i<Tape->Num_Chan; i++)
	if (Tape->Chan[i]->Symbol.Addr == NULL) null_chans++;

    if (Tape->Num_Chan - null_chans > 0)
      {

	fp = fopen(file_name, "w");
	
/* Write header info */

	fprintf(fp, "format  asc 1   .1      \n");
        fprintf(fp, "title   %s\n", progname);
        fprintf(fp, "nChans  %d\n", Tape->Num_Chan - null_chans);

/* Write data names 
 *  and emulate FORTRAN format statement:
 * 
 *     format(a8,8x,4a16:/(5a16))
 *
 */


        fprintf(fp, "names           ");
        names_written = 1;
        for (j = 0; j<Tape->Num_Chan; j++)
	  if ( Tape->Chan[j]->Symbol.Addr != NULL)
            {
                fprintf(fp, "%-16s", 
                        GDname( Tape->Chan[j]->Symbol.Par_Name,
                                namebuf ));
                names_written++;
                if (names_written >= NAMES_PER_LINE)
                    {
                        names_written = 0;
                        fprintf(fp, "\n");
                    }
            }
        if (names_written != 0) fprintf(fp, "\n");

/* Write data values */

        fprintf(fp, "data001 \n");
        
/* Need to emulate fortran format statement:
 *
 *  format(f10.3,10x,3g20.14:/(4g20.14))
 *
 */
	
	i = Tape->First;
	if (Tape->First < Tape->Last) wrapped = 0;

	while( wrapped || (i <= Tape->Last) )
	    {
		pts_written = 1;
		fprintf( fp, "% 10.3E           ", Tape->T_Stamp[i] );

		for (j = 0; j<Tape->Num_Chan; j++)
		    if ( Tape->Chan[j]->Symbol.Addr != NULL)
			{
			    fprintf(fp, "% 20.14E", Tape->Chan[j]->Data[i] );
			    pts_written++;
			    if (pts_written >= PTS_PER_LINE)
				{
				    pts_written = 0;
				    fprintf(fp, "\n");
				}

			}
		if (pts_written != 0) fprintf(fp, "\n");
		i = i + sim_control_.write_spacing;
		if ( i >= Tape->Length ) 
		    if ( wrapped )
			{
			    i = i - Tape->Length;
			    wrapped = 0;
			}
		    else
			{
			    i = Tape->Last+1;
			}
	    }

/* Write trailer info */

	fclose( fp );

      } /* end of Num_Chans > 0 */
}

