/***************************************************************************

	TITLE:	ls_tape.h
	
----------------------------------------------------------------------------

	FUNCTION:	Tape structure header file

----------------------------------------------------------------------------

	MODULE STATUS:	Developmental

----------------------------------------------------------------------------

	GENEALOGY:	920806 version for IRIS from Mac file

----------------------------------------------------------------------------

	DESIGNED BY:	B Jackson
	
	CODED BY:	B Jackson
	
	MAINTAINED BY:	B Jackson

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	931008	Added Max and Min value recording to save later sweeps of
		data for min and max...				EBJ

	950302	Moved symbol information structure to ls_sym.h	EBJ	
	
	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_tape.h,v 1.6 1995/04/07 01:43:08 bjax Exp $
$Log: ls_tape.h,v $
 * Revision 1.6  1995/04/07  01:43:08  bjax
 * Added #ifndef/#endif pair to protect from multiple invocations;
 * changed DATA types to SCALAR types; added Length field.
 *
 * Revision 1.5  1995/03/03  02:03:27  bjax
 * Moved def's of SYMBOL_NAME and SYMBOL_TYPE to ls_sym.h;
 * modified the CHANNEL structure to use new symbol_rec type
 * defined in ls_sym.h. EBJ
 *
 * Revision 1.4  1994/05/13  20:43:11  bjax
 * Changed number of MAX_SLICES from 10K to 32K.
 *
 * Revision 1.3  1993/12/20  16:49:04  bjax
 * Cleaned up the time slice vector; now a simple pointer to a DATA type;
 * application can treat it like the array it is.  EBJ
 *
 * Revision 1.2  1993/10/08  22:05:33  bjax
 * Added standard header; added min-max value element to each channel.  EBJ
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/
#include "ls_sym.h"
#ifndef TAPE
#define MAX_TAPE_CHANNELS 1024

typedef struct
{
	symbol_rec	Symbol;
	SCALAR		Max_value, Min_value;
	SCALAR		*Data;
}	CHANNEL;


typedef	struct
{
	int		Num_Chan;
	long		Length;
	int		First, Current, Next, Last;
	SCALAR		T_First, T_Current, T_Next, T_Last;
	SCALAR		Factor_1, Factor_2;
	SCALAR		*T_Stamp;		/* Pointer to an array of time stamps */
	CHANNEL		*Chan[ MAX_TAPE_CHANNELS ];	/* An array of handles
								to Chan structures */
}	TAPE;

#endif
