/***************************************************************************

	TITLE:		ls_ifterm.c
	
----------------------------------------------------------------------------

	FUNCTION:	UNIX curses terminal interface to LaRCsim

----------------------------------------------------------------------------

	MODULE STATUS:	developmental

----------------------------------------------------------------------------

	GENEALOGY:	Created 930202 by Bruce Jackson

----------------------------------------------------------------------------

	DESIGNED BY:	Bruce Jackson 
	
	CODED BY:	Bruce Jackson
	
	MAINTAINED BY:  

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY

	950226	Changed +a -s to -a +s to reflect correct sense of throttle
		keys; force simtype to terminal; added trim command 't';
		added header.					EBJ

	950329	Renamed from ls_ifsun.c v 1.4; cleaned up some. EBJ
	
	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_ifterm.c,v 1.1 1995/03/29 16:04:19 bjax Exp $

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

static char rcsid[] = "$Id: ls_ifterm.c,v 1.1 1995/03/29 16:04:19 bjax Exp $";


#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <curses.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include "ls_types.h"
#include "ls_generic.h"
#include "ls_constants.h"
#include "ls_sim_control.h"
#include "ls_cockpit.h"

#define TITLE 3
#define ESCKEY 0x1B

/* cockpit interface data block  - defn's in ls_cockpit.h */

#define aileron cockpit_.lat_stick
#define elevator cockpit_.long_stick
#define rudder cockpit_.rudder_pedal
#define throttle cockpit_.throttle_pct

COCKPIT cockpit_;

extern SCALAR Simtime; /* defined in ls_main */

static char *buf;

void drawhelp()
{
#define HELP 12
#define HELPCOL 20
  mvaddstr( HELP+0, HELPCOL, "              stick             ");
  mvaddstr( HELP+1, HELPCOL, "                                ");
  mvaddstr( HELP+2, HELPCOL, "                i               ");
  mvaddstr( HELP+3, HELPCOL, "throttle                 quit   ");
  mvaddstr( HELP+4, HELPCOL, "                |               ");
  mvaddstr( HELP+5, HELPCOL, " -a  +s      j -k- l     <ESC>  ");
  mvaddstr( HELP+6, HELPCOL, "                |               ");
  mvaddstr( HELP+7, HELPCOL, "                                ");
  mvaddstr( HELP+8, HELPCOL, "                <               ");
}

void drawpause()
{
  mvaddstr( HELP+0, HELPCOL, "                                ");
  mvaddstr( HELP+1, HELPCOL, "                                ");
  mvaddstr( HELP+2, HELPCOL, "                                ");
  mvaddstr( HELP+3, HELPCOL, "                                ");
  mvaddstr( HELP+4, HELPCOL, "    *** PAUSED (press P) ***    ");
  mvaddstr( HELP+5, HELPCOL, "                                ");
  mvaddstr( HELP+6, HELPCOL, "                                ");
  mvaddstr( HELP+7, HELPCOL, "                                ");
  mvaddstr( HELP+8, HELPCOL, "                                ");
}


int ls_cockpit()
{
	static int inited = 0;
	int nchr;
	int status;
	double sim_hr, sim_min, sim_sec;

	if (inited==0)
	{
		inited = -1;
		
		sim_control_.sim_type = terminal;

		buf = (char *) malloc(1000);
		initscr();
		cbreak();
		noecho();
		nonl();
		intrflush(stdscr,FALSE);
		keypad(stdscr,TRUE);

		move( TITLE, 3 );
		addstr( "L a R C S I M ");
		addstr(sim_control_.simname);

		mvaddstr( TITLE+2,  3, "Mach" );
		mvaddstr( TITLE+2, 18, "Psi" );
		mvaddstr( TITLE+2, 31, "NZ-G");
 		mvaddstr( TITLE+3,  3, "KEAS");
		mvaddstr( TITLE+3, 18, "Thet");
		mvaddstr( TITLE+3, 31, "Alt" );
		mvaddstr( TITLE+4,  3, "Throt");
		mvaddstr( TITLE+4, 18, "Phi" );
		mvaddstr( TITLE+4, 31, "Hdot");
		mvaddstr( TITLE+3, 46, "Alpha");
		mvaddstr( TITLE+4, 46, "Beta");
		mvaddstr( TITLE+6,  3, "Elevator");
		mvaddstr( TITLE+6, 23, "Aileron" );
		mvaddstr( TITLE+6, 41, "Rudder");
		drawhelp();
		if (sim_control_.paused) drawpause();
	}

	move( TITLE,   50 );

	sim_min = modf( Simtime/3600.0, &sim_hr )*60;
	sim_sec = modf( sim_min, &sim_min )*60;

	printw( "%01d:%02d:%04.1f", (int) sim_hr, (int) sim_min, sim_sec );
	move( TITLE+4, 10 ); printw( "%5.0f %%", throttle*100);
	move( TITLE+2,  9 ); printw( "%6.3f", Mach_number);
	move( TITLE+3,  9 ); printw( "%6.1f", V_equiv_kts);
	move( TITLE+2, 23 ); printw( "%5.1f", Psi*57.3);
	move( TITLE+3, 23 ); printw( "%5.1f", Theta*57.3);
	move( TITLE+4, 23 ); printw( "%5.1f", Phi*57.3);
	move( TITLE+2, 36 ); printw( "%7.3f", -N_Z_pilot);
	move( TITLE+3, 36 ); printw( "%7.0f", Altitude);
	move( TITLE+4, 36 ); printw( "%7.3f", -V_down);
	move( TITLE+3, 53 ); printw( "%5.2f", Alpha*57.3);
	move( TITLE+4, 53 ); printw( "%5.2f", Beta*57.3);
	move( TITLE+6, 15 ); printw( "%6.2f", elevator );
	move( TITLE+6, 33 ); printw( "%6.2f", aileron );
	move( TITLE+6, 51 ); printw( "%6.2f", rudder );

	move( TITLE+10, 1 );
	refresh();
	status = ioctl(0, FIONBIO);  /* set I/O to non-blocking */
	nchr = read(0, buf, 10);
	while (nchr > 0) 
	    {
		nchr=0;
		switch (*buf)
		    {
		    case ESCKEY:
			return -1;
			break;
		    case 'k':
			elevator = 0;
			aileron = 0;
			break;
		    case 'i':
			elevator = elevator + 0.01;
			break;
		    case ',':
			elevator = elevator - 0.01;
			break;
		    case 'j':
			aileron =  aileron - 0.01;
			break;
		    case 'l':
			aileron = aileron + 0.01;
			break;
		    case 'a':
			throttle = throttle - 0.01;
			break;
		    case 's':
			throttle = throttle + 0.01;
			break;
		    case 'p':
			if (sim_control_.paused)
			    {
				sim_control_.paused = FALSE;
				drawhelp();
				ls_resync(); /* turn timer back on */
			    }
			else
			    {
				sim_control_.paused = TRUE;
				drawpause();
				sim_control_.overrun = TRUE; /* will turn hud to red */
				ls_unsync(); /* turn timer off to disable interrupts */
			    }
			break;
		    case 'r':
			ls_init();
			break;
		    case 't':
			endwin();
			Q_body = 0.0;
			if (ls_trim()) ls_save_current_as_ic();
			break;
		    }
	    }
	return 0;
      }


void ls_cockpit_exit()

{
  endwin();
  free(buf);
}
