/***************************************************************************

	TITLE:		ls_funcgen.h
	
----------------------------------------------------------------------------

	FUNCTION:	Function generation routines header file

----------------------------------------------------------------------------

	MODULE STATUS:	Developmental

----------------------------------------------------------------------------

	GENEALOGY:	Developed circa 1991 by E. B. Jackson; installed
			as part of LaRCSim 930319.

----------------------------------------------------------------------------

	DESIGNED BY:	B. Jackson
	
	CODED BY:	B. Jackson
	
	MAINTAINED BY:	B. Jackson

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_funcgen.h,v 1.1 1993/03/19 07:02:32 bjax Stab $
$Log: ls_funcgen.h,v $
 * Revision 1.1  1993/03/19  07:02:32  bjax
 * Initial revision
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#define MAX_DIMENSION  6
#define MAX_LENGTH  63
#define	MAX_DATA_NAME_LENGTH  15

typedef double DATA;

typedef	struct
{
	long	index[ MAX_DIMENSION ];
	float	index_and_weight[ MAX_DIMENSION ];
}	ARG_LIST;

typedef struct
{
	char	name[ MAX_DATA_NAME_LENGTH ];
	int		length;
	DATA	bkPts[ MAX_LENGTH ];
} BREAKPOINTS;

typedef struct 
{
	char	name[ MAX_DATA_NAME_LENGTH ];
	int		dim;
	int		length[MAX_DIMENSION];
	DATA	*pts;
}	FUNC_DATA;

typedef struct
{
	char		name[ MAX_DATA_NAME_LENGTH ];
	FUNC_DATA	*ptr_to_data;
	BREAKPOINTS	*bkPtList[ MAX_DIMENSION ];
	float		latest_index_and_weights[ MAX_DIMENSION ];
	DATA		latest_bkpt_value[ MAX_DIMENSION ];
}	NONLINEAR_FUNCTION;

float normalize_bkpt( NONLINEAR_FUNCTION *nlfunct,int dim, DATA value);

DATA funcgen( NONLINEAR_FUNCTION *func_ptr, ARG_LIST *arg_list, int dim);
