/***************************************************************************

	TITLE:		ls_err.c
	
----------------------------------------------------------------------------

	FUNCTION:	Error reporting routines

----------------------------------------------------------------------------

	MODULE STATUS:	Developmental

----------------------------------------------------------------------------

	GENEALOGY:	Written 9112 to support Mex files; installed as
			part of LaRCSim software

----------------------------------------------------------------------------

	DESIGNED BY:	B. Jackson
	
	CODED BY:	B. Jackson
	
	MAINTAINED BY:	B. Jackson

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY

	940106	Redirected error output to "stderr"		EBJ
	
	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_err.c,v 1.2 1994/01/11 18:25:24 bjax Stab $
$Log: ls_err.c,v $
 * Revision 1.2  1994/01/11  18:25:24  bjax
 * Redirected output to stderr from stdout.
 *
 * Revision 1.1  1993/03/19  07:22:27  bjax
 * Initial revision
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#include "ls_err.h"
#include <string.h>
#include <stdio.h>

#define NO_MSG "No message."


ERROR  error = {  info,
          E_NO_ERROR,
          0,
          0,
          0., 0., 0.,
          0, 0, 0        };

char  *report_error(  ERROR  *err_block )

{
  char  error_msg[ ERROR_STRING_LENGTH ];
  char  *err_msg_p;
  float  *flt_p;
  int    *int_p;
  
  err_msg_p = &error_msg[0];
  while (*err_msg_p++ = *err_block->strg1++)
  {
    switch (*err_block->strg1)
    {
      case '&':  /* place to insert parameter */
      {
        (err_block->strg1)++;    /* skip over '&' sign */
        switch (*err_block->strg1)  /* and evaluate next char */
        {
          case 'f':  /* float parameters */
          {
            (err_block->strg1)++;  /* skip past 'f' char */
            switch (*err_block->strg1)  /* and eval next  */
            {
              case '1':
              {  /* convert param fp1 to string */
                flt_p = &err_block->fp1;
                break;
              }
              case '2':
              {  /* convert param fp2 to string */
                flt_p = &err_block->fp2;
                break;
              }
              case '3':
              {  /* convert param fp3 to string */
                flt_p = &err_block->fp3;
                break;
              }
              default:
                /* print error message - not '&f[123]' */;
            }
            err_msg_p = err_msg_p + (int)sprintf( err_msg_p, "%e", *flt_p );
            err_block->strg1++;
            break;
          }
          case 'i':  /* Integer parameter */
          {
            (err_block->strg1)++;  /* skip past 'i' char */
            switch (*err_block->strg1)  /* and eval next  */
            {
              case '1':
              {  /* convert param ip1 to string */;
                int_p = &err_block->ip1;
                break;
              }
              case '2':
              {  /* convert param ip2 to string */;
                int_p = &err_block->ip2;
                break;
              }
              case '3':
              {  /* convert param ip3 to string */;
                int_p = &err_block->ip3;
                break;
              }
              default:
                /* print error message - not '&i[123]' */;
            }
            err_msg_p = err_msg_p + (int)sprintf( err_msg_p, "%d", *int_p );
            err_block->strg1++;
            break;
          }
          case 's':  /* string parameter */
          {
            (err_block->strg1)++;  /* skip past 's' char */
            switch (*err_block->strg1)  /* and eval next  */
            {
              case '1':  /* error - can only be a 2 */
                /* convert param fp1 to string */;
              case '2':
              {  /* convert param fp2 to string */;
                err_msg_p = err_msg_p + (int)sprintf( err_msg_p, err_block->strg2 );
                err_block->strg1++;
                break;
              }
              case '3':  /* error - can only be a 2 */
                /* convert param fp3 to string */;
              default:
                /* print error message - not '&s[123]' */;
            }
            break;
          }
          default:  /* error - ampersand alone */
          {
            /* print error message */
          }
        }
      }
    }    
  }
  fprintf(stderr, "%s",&error_msg[0]);
  return &error_msg[0];
}


