/***************************************************************************

	TITLE:	    ls_ACES.h
	
----------------------------------------------------------------------------

	FUNCTION:	Include file for routines that use the ACES cockpit

----------------------------------------------------------------------------

	MODULE STATUS:	incomplete

----------------------------------------------------------------------------

	GENEALOGY:	Created 930215 by E. B. Jackson

----------------------------------------------------------------------------

	DESIGNED BY:	E. B. Jackson
	
	CODED BY:	E. B. Jackson
	
	MAINTAINED BY:	E. B. Jackson

----------------------------------------------------------------------------

	MODIFICATION HISTORY:
	
	DATE	PURPOSE						BY
	
	CURRENT RCS HEADER:

$Header: /aces/larcsim/dev/RCS/ls_ACES.h,v 1.4 1995/02/28 20:35:40 bjax Stab $
$Log: ls_ACES.h,v $
 * Revision 1.4  1995/02/28  20:35:40  bjax
 * Changed name of GEAR_SEL_DOWN to GEAR_SEL_UP to reflect correct
 * sense of switch. EBJ
 *
 * Revision 1.3  1994/07/12  21:36:13  bjax
 * Fixed error between SB_EXTEND and SB_RETRACT
 * bits.
 *
 * Revision 1.2  1994/04/11  20:41:17  bjax
 * Added rudder pedal calibration data & scaling to support THRUSTMASTER!
 *
 * Revision 1.1  1994/02/15  20:37:09  bjax
 * Initial revision
 *

----------------------------------------------------------------------------

	REFERENCES:

----------------------------------------------------------------------------

	CALLED BY:

----------------------------------------------------------------------------

	CALLS TO:

----------------------------------------------------------------------------

	INPUTS:

----------------------------------------------------------------------------

	OUTPUTS:

--------------------------------------------------------------------------*/

#define VMIC3114_CONTROL_ADDR   0x00006000
#define VMIC3114_CONTROL_LENGTH 0x20
#define VMIC3114_CONTROL_BUS_DEVICE "/dev/vme/vme0a16n"

#define VMIC3114_DATA_ADDR   0x00C00000
#define VMIC3114_DATA_LENGTH 0x00040000
#define VMIC3114_DATA_BUS_DEVICE "/dev/vme/vme0a24n"

#define LANDING_GEAR_UP     0x0010
#define SPEEDBRAKE_EXTEND   0x0040
#define SPEEDBRAKE_RETRACT  0x0080
#define LEFT_PUSH_BUTTON    0x0100
#define RIGHT_PUSH_BUTTON   0x0200
#define SECOND_TRIG_BUTTON  0x0400
#define FIRST_TRIG_BUTTON   0x0800
#define RIGHT_TRIM	    0x1000
#define FWD_TRIM	    0x2000
#define AFT_TRIM	    0x4000
#define LEFT_TRIM	    0x8000

  
    typedef struct
    {
	float thraft[4];    /* aft throttle stop A/D values	*/
	float thrfwd[4];    /* fwd throttle stop A/D values	*/
	float stkaft;	    /* aft long stick stop A/D value	*/
	float stklg0;	    /* center long stick stop A/D value */
	float stkfwd;	    /* fwd long stick stop A/D value	*/
	float stklft;	    /* left lat stick stop A/D value	*/
	float stklt0;	    /* center lat stick stop A/D value	*/
	float stkrgt;	    /* right lat stick stop A/D value	*/
	float pedlft;	    /* left rudder pedal stop A/D value */
	float pedctr;	    /* center rudder pedal A/D value	*/
	float pedrgt;	    /* right rudder pedal stop A/D val  */
    } CALIBRATION_DATA;
