# LXNavigation Eos57 Vario by Benedikt Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

# THANKS TO Colin Geniet (SoundPitchController), original developers of the ilec-sc7 (WooT)

# Information based on manual https://downloads.lxnavigation.com/downloads/manuals/Eos/LX-Eos_users_manual_1_7.pdf
#######################################

## REQUIRES:
##	* second airspeed indicator module enabled from <sim><instrumentation> ("eos-airspeed-indicator")
##	* second altimeter module enabled from <sim><instrumentation> ("eos-altimeter")
##	* power supply from systems/electrical/outputs/eos
##	(opt) * vario sound set up in the aircraft's sound file (see eos-sound.txt as an example)

var state = 0;		#	0 = off, 1 = init/firmware, 2 = select pilot, 3 = set elevation, 4 = set QNH, 5 = ON

var zeus_coupled = 1; # used with Zeus navigation display

var Eos_start = nil;
var Eos_main = [ nil ];
var Eos_display = nil;

var eos	=	props.globals.initNode("/instrumentation/eos");

var te_rdg	=	eos.initNode("te-reading-mps", 0.0, "DOUBLE");
var te_avg	=	eos.initNode("te-average-mps", 0.0, "DOUBLE");
var volume	=	eos.initNode("volume", 0.5, "DOUBLE");

setprop("instrumentation/eos-altimeter/serviceable", 1 );
setprop("instrumentation/eos-airspeed-indicator/serviceable", 1 );

var alt		=	props.globals.getNode("instrumentation/eos-altimeter/indicated-altitude-ft", 1);
var press_alt	=	props.globals.getNode("instrumentation/eos-altimeter/pressure-alt-ft", 1);
var qnh		=	props.globals.getNode("instrumentation/eos-altimeter/setting-hpa", 1);
var ias_kt		=	props.globals.getNode("instrumentation/eos-airspeed-indicator/indicated-speed-kt", 1);
var tas_kt		=	props.globals.getNode("instrumentation/eos-airspeed-indicator/true-speed-kt", 1);

var g_accel =	props.globals.getNode("accelerations/pilot-g", 1);
var g_max = [ 1.0, 1.0 ];

var oat		=	props.globals.getNode("environment/temperature-degc", 1);

var gps = {
	lat:	props.globals.getNode("position/latitude-string"),
	lon:	props.globals.getNode("position/longitude-string"),
	trk:	props.globals.getNode("/orientation/track-deg"),
};

var wind = {
	hdg: props.globals.getNode("/environment/wind-from-heading-deg", 1),
	spd: props.globals.getNode("/environment/wind-speed-kt", 1),
};

var hdg_true	=	props.globals.getNode("/orientation/heading-deg",	1);


var volt_prop	=	props.globals.getNode("/systems/electrical/outputs/zeus", 1);

var mc		=	eos.initNode( "mc", 1.5, "DOUBLE" );

var needle		=	eos.initNode( "needle-deg", 0.0, "DOUBLE" );

var instrument_dir	=	"Aircraft/miniLAK/Models/Instruments/Eos57/";

var canvas_Eos_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = volt_prop.getDoubleValue();
		if( volts > 9 ){
			if( state == 2 ){
				Eos_main[0].page.show();
				Eos_main[0].update();

				Eos_start.page.hide();

				check_g_force();
			} elsif( state == 1 ) {
				Eos_start.page.show();
				foreach( var el; Eos_main ){
					el.page.hide();
				}
			} else {
				foreach( var el; Eos_main ){
					el.page.hide();
				}
				Eos_start.page.hide();
			}
		} else {
			foreach( var el; Eos_main ){
				el.page.hide();
			}
			Eos_start.page.hide();
		}
	},
};

var check_g_force = func{
	var current_val = g_accel.getDoubleValue();

	if( current_val < g_max[0] ) {
		g_max[0] = current_val;
	} elsif( current_val > g_max[1] ) {
		g_max[1] = current_val;
	}
}
	
var batt_ind_state = -1; # 0 = green, 1 = yellow, 2 = red
var canvas_Eos_vario = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_Eos_vario , canvas_Eos_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "avg.digits", "alt.digits", "green_arch.digits", "groundspeed.digits","wind.text", "batt.1", "batt.2", "batt.3" ];
	},
	update: func() {
		me["avg.digits"].setText( sprintf("%2.1f", te_avg.getDoubleValue() ) );
		
		me["groundspeed.digits"].setText( sprintf("%3d", math.round( zeus.gs_kt.getDoubleValue() * KT2MPS * 3.6 ) ) );
		
		me["alt.digits"].setText( sprintf("%4d", math.round( zeus.alti_ft.getDoubleValue() * FT2M ) ) );
		
		me["green_arch.digits"].setText( sprintf("%2.1f", te_rdg.getDoubleValue() ) );
		
		# Wind Indication
		var wind_heading = wind.hdg.getDoubleValue();
		var ac_heading = hdg_true.getDoubleValue();
		me["wind.text"].setText( sprintf("%3d", math.round( wind_heading ) ) ~ "° /" ~ sprintf("%3d", math.round( wind.spd.getDoubleValue() * KT2MPS * 3.6 ) ) );
		
		# Battery Indication
		var volts = volt_prop.getDoubleValue();
		if( volts > 12.0 and batt_ind_state != 0 ){
			batt_ind_state = 0;
			me["batt.1"].show();
			me["batt.2"].show();
			me["batt.1"].setColorFill( 0, 1, 0 );
			me["batt.2"].setColorFill( 0, 1, 0 );
			me["batt.3"].setColorFill( 0, 1, 0 );
		} elsif( volts <= 12.0 and volts > 10.8 and batt_ind_state != 1 ){
			batt_ind_state = 1;
			me["batt.1"].hide();
			me["batt.2"].show();
			me["batt.1"].setColorFill( 1, 1, 0 );
			me["batt.2"].setColorFill( 1, 1, 0 );
			me["batt.3"].setColorFill( 1, 1, 0 );
		} elsif( volts <= 10.8 and batt_ind_state != 2 ){
			batt_ind_state = 2;
			me["batt.1"].hide();
			me["batt.2"].hide();
			me["batt.1"].setColorFill( 1, 0, 0 );
			me["batt.2"].setColorFill( 1, 0, 0 );
			me["batt.3"].setColorFill( 1, 0, 0 );
		}
			
	}

};

var canvas_Eos_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_Eos_start , canvas_Eos_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
};

var eos_update = maketimer(0.05, func() { canvas_Eos_base.update() } );
eos_update.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	Eos_display = canvas.new({
		"name": "Eos",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	Eos_display.addPlacement({"node": "eos57.screen"});

	Eos_start = canvas_Eos_start.new(Eos_display.createGroup(), instrument_dir~"eos57_start.svg");
	Eos_main[0] = canvas_Eos_vario.new(Eos_display.createGroup(), instrument_dir~"eos57_vario.svg");
	
	eos_update.start();
	
	removelistener(ls);
});

var check_electric_off = func () {
	if( volt_prop.getDoubleValue() < 9.0 and state != 0 ){
		state = 0;
	}
}


var power_btn = func {
	if( volt_prop.getDoubleValue() >= 9.0 and state == 0 ){
		state = 1;
		settimer( func{ state = 2; }, 1 + rand() * 1.0 );
	} else {
		check_electric_off();
	}
}

var btn = func{
	if( state == 0 ) power_btn();
#	elsif( state <  5 ) switch_state();
}

var knob = func( dir ){
}


setlistener(volt_prop, func {
	check_electric_off();
});



#The following code is based on the ILEC SC7 e-vario and computes the different values shown by the display
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

####################################
####	INSTRUMENT SETUP	####
####################################

# Vario sound pitch controller by Colin Geniet (for ASK21), thanks!
#
# var vario_sound = SoundPitchController.new(
#   input: Object connected to the pitch controller input, e.g. a variometer reading.
#   max_pitch: (optional) Maximum sound frequency factor, the output will be
#              in the range [1/max_pitch, max_pitch], default 2.
#   max_input: Value of input for which max_pitch is reached.
#	on_update: (optional) function to call whenever a new output is available

var SoundPitchController = {
	parents: [InstrumentComponent],
	
	new: func(input, max_input, max_pitch = 2, on_update = nil) {
		return {
			parents: [me],
			input: input,
			max_pitch: max_pitch,
			max_input: max_input,
			on_update: on_update,
		};
	},
	
	update: func {
		var input = math.clamp(me.input.output, -me.max_input, me.max_input);
		me.output = math.pow(me.max_pitch, input / me.max_input);
		
		if (me.on_update != nil) me.on_update(me.output);
	},
};

var probe = TotalEnergyProbe.new();

var eos_needle = Dampener.new(
	input: probe,
	dampening: 1.5, 
	on_update: update_prop("/instrumentation/eos/te-reading-mps"));#1.5 is default dampening value according to POH

var averager = Averager.new(
	input: probe,
	buffer_size: 20,
	on_update: update_prop("/instrumentation/eos/te-average-mps")); #20s is default time according to POH
	
var eos_sound = SoundPitchController.new(
	input: eos_needle,
	max_input: 5,
	on_update: update_prop("/instrumentation/eos/sound-pitch"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, eos_needle, eos_sound],
	enable: 1);

var slow_instruments = UpdateLoop.new(
	update_period: 1,
	components: [averager],
	enable: 1);
	
