
var instrument_prop = props.globals.initNode("/instrumentation/lx8080");
var instrument_path = "Aircraft/DG-505/Models/Interior/Instruments/LX8080/";

var volts = props.globals.getNode("/systems/electrical/outputs/lx[0]", 1);
var start = instrument_prop.initNode("start", 0.0, "DOUBLE");

var active = 0;
var active_p = instrument_prop.initNode("active", 0, "BOOL");	# used by buttons/knobs

var instr_settings = instrument_prop.initNode( "settings" );
var zoom = instr_settings.initNode( "zoom-km", 1, "INT" );
var page = instr_settings.initNode( "page", 1, "INT" );	# 1 / 2 / 3 / 4


var time_hr	=	props.globals.getNode("/sim/time/utc/hour", 1);
var time_min	=	props.globals.getNode("/sim/time/utc/minute", 1);

var wind_deg	=	props.globals.getNode("/environment/wind-from-heading-deg", 1);
var wind_kt	=	props.globals.getNode("/environment/wind-speed-kt",	1);

var vario_te	=	props.globals.getNode("/instrumentation/ilec-sc7/te-reading-mps", 1);
var vario_av	=	instrument_prop.getNode("average-reading-mps", 1);

var alt_agl	=	props.globals.getNode("/position/altitude-agl-ft", 	1);
var alt_gps	=	props.globals.getNode("/position/altitude-ft", 		1);

var gs_kt	=	props.globals.getNode("/velocities/groundspeed-kt", 	1);

var hdg_trk	=	props.globals.getNode("/orientation/track-deg",		1);
var hdg_true	=	props.globals.getNode("/orientation/heading-deg",	1);

var alti_ft		=	props.globals.getNode("/instrumentation/altimeter[1]/indicated-altitude-ft", 1);
var alti_press_ft	=	props.globals.getNode("/instrumentation/altimeter[1]/pressure-alt-ft", 1);

var oat_degc	=	props.globals.getNode("/environment/temperature-degc",	1);

var stat_press	=	props.globals.getNode("/systems/static[1]/pressure-inhg", 1);

var hdg = props.globals.getNode("orientation/heading-magnetic-deg");
var hdgBug = props.globals.getNode("autopilot/settings/heading-bug-deg");
var lon = props.globals.getNode("position/longitude-deg");
var lat = props.globals.getNode("position/latitude-deg");

var vario_te = instrument_prop.initNode( "te-reading-mps", 0.0, "DOUBLE" );
