# EXPORT : functions ending by export are called from xml
# CRON : functions ending by cron are called from timer
# SCHEDULE : functions ending by schedule are called from cron
# HUMAN : functions ending by human are called by artificial intelligence



# This file contains 3D feedbacks.



# ==========
# HUMAN CREW
# ==========

Crewhuman = {};

Crewhuman.new = func {
   var obj = { parents : [Crewhuman,System.new("/systems/human")]
         };

   obj.init();

   return obj;
}

Crewhuman.init = func {
}

Crewhuman.wakeupexport = func {
   me.wakeup();
}

Crewhuman.schedule = func {
}

Crewhuman.wakeup = func {
}


# =============
# HUMAN COPILOT
# =============

Copilothuman = {};

Copilothuman.new = func {
   var obj = { parents : [Copilothuman,Crewhuman.new()]
         };

   return obj;
}


# ==============
# HUMAN ENGINEER
# ==============

Engineerhuman = {};

Engineerhuman.new = func {
   var obj = { parents : [Engineerhuman,Crewhuman.new()],

               seat : Engineerseat.new()
         };

   return obj;
}

Engineerhuman.set_relation = func( seat ) {
   me.seat.set_relation( seat );
}

Engineerhuman.wakeupexport = func {
   me.wakeup();
   
   # reset seat
   me.slowschedule();
}

Engineerhuman.railexport = func {
   me.seat.toggle();

   me.slowschedule();
}

Engineerhuman.slowschedule = func {
   me.seat.schedule();
}


# =============
# ENGINEER SEAT
# =============

Engineerseat = {};

Engineerseat.new = func {
   var obj = { parents : [Engineerseat,System.new("/systems/human")],

               seatsystem : nil,
               
               callout : Callout.new(),

               SEATDEGPSEC : 25.0,

               BOGGIESEC : 1.5,

               FLIGHTDEG : 270,
               TAKEOFFDEG : 0,                                          # towards pedestal

               headdeg : 0,

               STATICDEG : 0,

               headnorm : 0.0,
               
               interface : constant.FALSE,

               TAKEOFF : 1.0,                                           # near pedestal
               FLIGHT : 0.0
         };

   obj.init();

   return obj;
}

Engineerseat.init = func {
   me.headdeg = me.dependency["engineer"].getChild("heading-deg").getValue();
}

Engineerseat.set_relation = func( seat ) {
   me.seatsystem = seat;
}

# pedestal view
Engineerseat.toggle = func {
   if( !me.is_stowed() ) {
       var pos = me.itself["engineer"].getChild("move-norm").getValue();

       if( pos == me.FLIGHT ) {
           me.interface = constant.TRUE;
       }
       elsif( pos == me.TAKEOFF ) {
           me.interface = constant.FALSE;
       }
   }
}

Engineerseat.is_stowed = func {
   var result = constant.TRUE;

   if( me.itself["engineer"].getChild("stowe-norm").getValue() == me.FLIGHT ) {
       result = constant.FALSE;
   }

   return result;
}

Engineerseat.is_rotating = func {
   var result = constant.FALSE;

   me.callout.receive();
   if( me.callout.is_holding() or me.callout.is_takeoff() or me.callout.is_landing() ) {
       result = constant.TRUE;
   }

   return result;
}

Engineerseat.schedule = func {
   var target = me.interface;
   
   if( me.itself["engineer-ctrl"].getChild("activ").getValue() ) {
       # move the seat, only with 3D crew
       if( me.itself["engineer-ctrl"].getChild("move").getValue() ) {
           target = me.is_rotating();
       }
   }
 
   me.movement( target );
}

Engineerseat.movement = func( takeoff ) {
   var next = constant.FALSE;
   var targetdeg = 0.0;
   var target = me.FLIGHT;

   # takeoff position
   if( takeoff ) {
       if( !me.is_stowed() ) {
           targetdeg = me.TAKEOFFDEG;           
           target = me.TAKEOFF;
           
           me.headdeg = me.itself["engineer"].getChild("view-deg").getValue();
           me.headnorm = me.itself["engineer"].getChild("move-norm").getValue();

           # rotation, then translation, in 2 distinct steps
           if( me.headdeg != targetdeg ) {
               me.rotate( targetdeg, constant.FALSE );
               me.itself["engineer"].getChild("view-deg").setValue(targetdeg);
               next = constant.TRUE;
           }

           elsif( me.headnorm != target ) {
               me.translate( target );
               me.itself["engineer"].getChild("move").setValue(constant.TRUE);
           }
           
           else {
               me.itself["engineer"].getChild("move").setValue(constant.TRUE);
           }
       }
   }

   # flight position
   else {
       target = me.FLIGHT; 
           
       me.headnorm = me.itself["engineer"].getChild("move-norm").getValue();

       # reversed order
       if( me.headnorm != target ) {
           me.translate( target );
           me.rotateclear();
           me.moveclear();
       }
           
       else {
           me.rotateclear();
           me.moveclear();
       }
   }
   
   return next;
}

Engineerseat.reset = func {
   me.translateclear();
   me.rotateclear();

   me.moveclear();
}

Engineerseat.clear = func {
   me.moveclear();
}

Engineerseat.rotate = func( targetdeg, clear ) {
    var movementdeg = 0.0;
    var movementsec = 0.0;

    # freezes seat angle, if still in engineer view
    me.seatsystem.engineerhead();

    me.headdeg = targetdeg;

    if( !clear ) {
        var viewdeg = me.dependency["engineer"].getChild("heading-deg").getValue();

        # correction by engineer view rotation
        movementdeg = targetdeg - viewdeg;
        movementdeg = geo.normdeg180( movementdeg );
        movementsec = math.abs( movementdeg / me.SEATDEGPSEC );
    }

    # clears engineer rotation
    else {
        var seatdeg = me.itself["engineer"].getChild("seat-deg").getValue();

        movementdeg = me.STATICDEG;
        movementsec = math.abs( seatdeg / me.SEATDEGPSEC );
    }


    interpolate(me.itself["engineer"].getChild("seat-deg").getPath(), movementdeg, movementsec );
}

Engineerseat.translate = func( target ) {
    me.headnorm = target;

    interpolate(me.itself["engineer"].getChild("move-norm").getPath(), me.headnorm, me.BOGGIESEC );
}

Engineerseat.moveclear = func {
    me.itself["engineer"].getChild("move").setValue(constant.FALSE);
}
 
Engineerseat.rotateclear = func {
    me.headdeg = me.FLIGHTDEG;
    me.itself["engineer"].getChild("seat-deg").setValue(me.STATICDEG);
    me.itself["engineer"].getChild("view-deg").setValue(me.FLIGHTDEG);
}

Engineerseat.translateclear = func {
    me.headnorm = me.FLIGHT;
    me.itself["engineer"].getChild("move-norm").setValue(me.FLIGHT);
}


# =========
# SEAT RAIL
# =========

SeatRail = {};

SeatRail.new = func {
   var obj = { parents : [SeatRail,System.new("/systems/human")],

               RAILSEC : 5.0,

               ENGINEERDEG : 270,
  
               FLIGHT : 0.0,
               PARK : 1.0
         };

   return obj;
}

SeatRail.toggle = func( seat ) {
   var canstowe = constant.TRUE;

   if( seat == "engineer" ) {
       if( me.itself["engineer"].getChild("stowe-norm").getValue() == me.FLIGHT ) {
           # except if seat has moved
           if( me.itself["engineer"].getChild("seat-deg").getValue() > 0 or
               me.itself["engineer"].getChild("move-norm").getValue() > 0 or
               me.dependency["engineer"].getChild("heading-deg").getValue() != me.ENGINEERDEG ) {
               canstowe = constant.FALSE;
           }
       }
   }

   if( canstowe ) {
       me.roll(me.itself[seat].getChild("stowe-norm").getPath());
   }
}

SeatRail.is_stowed = func( seat ) {
   var result = constant.FALSE;

   if( me.itself["root"].getNode(seat).getChild("stowe-norm").getValue() == me.PARK ) {
       result = constant.TRUE;
   }

   return result;
}

# roll on rail
SeatRail.roll = func( path ) {
   var pos = getprop(path);

   if( pos == me.FLIGHT ) {
       interpolate( path, me.PARK, me.RAILSEC );
   }
   elsif( pos == me.PARK ) {
       interpolate( path, me.FLIGHT, me.RAILSEC );
   }
}
