#Zander ZS1 Segelflugrechner based on manual http://www.zander-variometer.de

var ZS1_only = nil;
var ZS1_display = nil;
var page = "only";

var canvas_ZS1_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Regular.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ((getprop("/systems/electrical/volts") or 0) >= 10) {
				ZS1_only.page.show();
		} else {
			ZS1_only.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};

var canvas_ZS1_only = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ZS1_only,canvas_ZS1_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
			
		
		settimer(func me.update(), 0.02);
	},
};

setlistener("sim/signals/fdm-initialized", func {
	ZS1_display = canvas.new({
		"name": "MFD",
		"size": [512, 512],
		"view": [512, 512],
		"mipmapping": 1
	});
	ZS1_display.addPlacement({"node": "ZS1.screen"});
	var groupZS1 = ZS1_display.createGroup();

	ZS1_only = canvas_ZS1_only.new(groupZS1, "Aircraft/ASG29/Models/Instruments/ZS1/ZS1.canvas.svg");

	ZS1_only.update();
	canvas_ZS1_base.update();
});

var showZS1 = func {
	var dlg = canvas.Window.new([512, 512], "dialog").set("resize", 1);
	dlg.setCanvas(ZS1_display);
}
