package zed.rainxch.githubstore.core.data.local.db

import androidx.room.Room
import androidx.sqlite.driver.bundled.BundledSQLiteDriver
import kotlinx.coroutines.Dispatchers
import java.io.File

fun initDatabase(): AppDatabase {
    val dbFile = File(System.getProperty("java.io.tmpdir"), "github_store.db")
    return Room
        .databaseBuilder<AppDatabase>(
            name = dbFile.absolutePath,
        )
        .setDriver(BundledSQLiteDriver())
        .setQueryCoroutineContext(Dispatchers.IO)
        .fallbackToDestructiveMigration(true)
        .build()
}