<div align="center">
<img src="https://github.com/rainxchzed/Github-Store/blob/main/composeApp/src/commonMain/composeResources/drawable/app-icon.png" width="200" alt="Логотип проекта"/>
</div>

<h1 align="center">GitHub Store</h1>

<p align="center">
  <a href="https://opensource.org/licenses/Apache-2.0"><img alt="Лицензия" src="https://img.shields.io/badge/License-Apache%202.0-blue.svg"/></a>
  <a href="https://kotlinlang.org"><img alt="Kotlin" src="https://img.shields.io/badge/Kotlin-Multiplatform-7F52FF.svg"/></a>
  <a href="#"><img alt="Платформы" src="https://img.shields.io/badge/Platforms-Android%20%7C%20Desktop-brightgreen"/></a>
  <a href="https://github.com/rainxchzed/Github-Store/releases">
    <img alt="Релиз" src="https://img.shields.io/github/v/release/rainxchzed/Github-Store?label=Release&logo=github"/>
  </a>
  <a href="https://github.com/rainxchzed/Github-Store/stargazers">
    <img alt="Звёзды GitHub" src="https://img.shields.io/github/stars/rainxchzed/Github-Store?style=social"/>
  </a>
  <img alt="Compose Multiplatform" src="https://img.shields.io/badge/Compose-Multiplatform-4285F4?logo=jetpackcompose&logoColor=white"/>
  <img alt="Koin" src="https://img.shields.io/badge/DI-Koin-3C5A99?logo=kotlin&logoColor=white"/>
</p>

<p align="center">
<a href="/docs/README-RU.md" target="_blank"> Русский </a> | <a href="/README.md" target="_blank"> English </a> | <a href="/docs/README-ES.md" target="_blank"> Español </a> | <a href="/docs/README-FR.md" target="_blank"> Français </a> | <a href="/docs/README-KR.md" target="_blank"> 한국어 </a> | <a href="/docs/README-ZH.md" target="_blank">中文</a> | <a href="/docs/README-JA.md" target="_blank">日本語</a>
</p>

<p align="center">
GitHub Store — это кроссплатформенный «Play Store» для релизов GitHub.
Он находит репозитории с реальными устанавливаемыми бинарниками и позволяет
устанавливать, отслеживать и обновлять их на разных платформах из одного места.
</p>

<p align="center">
  <img src="../screenshots/banner.png" />
</p>

---

### Все скриншоты можно найти в папке [screenshots/](screenshots/).

<img src="/screenshots/preview.gif" align="right" width="320"/>

## ✨ Что такое GitHub Store?

GitHub Store — это приложение на Kotlin Multiplatform (Android + Desktop),
которое превращает GitHub Releases в удобный интерфейс в стиле магазина приложений:

- Показывает только репозитории, которые действительно предоставляют устанавливаемые файлы (APK, EXE, DMG, AppImage, DEB, RPM и т.д.).
- Определяет вашу платформу и предлагает подходящий установщик.
- Всегда устанавливает последнюю опубликованную версию, показывает список изменений и может уведомлять об обновлениях установленных приложений (на Android).
- Отображает детальный экран с статистикой, README и информацией о разработчике.

---

## 🔃 Загрузка

<a href="https://github.com/rainxchzed/Github-Store/releases">
   <image src="https://i.ibb.co/q0mdc4Z/get-it-on-github.png" height="80"/>
 </a>

<a href="https://f-droid.org/en/packages/zed.rainxch.githubstore/">
   <image src="https://f-droid.org/badge/get-it-on.png" height="80"/>
</a>

> [!IMPORTANT]
> В macOS может появиться предупреждение о том, что Apple не может проверить GitHub Store
> на наличие вредоносного ПО. Это связано с тем, что приложение распространяется вне App Store
> и пока не нотарифицировано. Вы можете разрешить запуск через
> System Settings → Privacy & Security → Open Anyway.

---

## 🏆 Где нас отметили

<a href="https://www.youtube.com/@howtomen">
  <img src="https://img.shields.io/badge/Featured%20by-HowToMen-red?logo=youtube" alt="Отмечено HowToMen">
</a>

- **HowToMen**: [Топ-20 лучших Android-приложений 2026 года (860 тыс. подписчиков)](https://www.youtube.com/watch?v=7favc9MDedQ)
- **F-Droid**: [1-е место в категории App Store](https://f-droid.org/en/categories/app-store-updater/)

---

## 🚀 Возможности

- **Умный поиск**
    - Разделы главной страницы: «Trending», «Recently Updated» и «New» с фильтрацией по времени.
    - Отображаются только репозитории с валидными устанавливаемыми файлами.
    - Учет платформы при ранжировании, чтобы пользователи Android/desktop видели релевантные приложения первыми.

- **Установка последних релизов**
    - Используется `/releases/latest` для каждого репозитория.
    - Показываются только файлы из последнего релиза.
    - Одна кнопка «Install latest» и разворачиваемый список всех установщиков для этого релиза.

- **Подробный экран приложения**
    - Название приложения, версия, кнопка «Install latest».
    - Звёзды, форки, открытые issues.
    - Отрендеренный README («О приложении»).
    - Заметки последнего релиза с поддержкой Markdown.
    - Список установщиков с указанием платформ и размера файлов.

- **Кроссплатформенный UX**
    - Android: открывает APK через системный установщик, отслеживает установки в локальной базе данных и показывает их в отдельном разделе с индикаторами обновлений.
    - Desktop (Windows/macOS/Linux): загружает установщики в папку «Загрузки» пользователя и открывает их стандартным обработчиком.

- **Внешний вид и темы**
    - Дизайн Material 3 с компонентами **Material 3 Expressive** на всех платформах.
    - Поддержка динамических цветов Material You на Android (где доступно).
    - Опциональный AMOLED-чёрный режим для OLED-устройств.

- **Безопасность и проверка (Android)**
    - Опциональный вход через GitHub OAuth (Device Flow) для увеличения лимитов API.
    - Действие «Open in AppManager» для проверки разрешений и трекеров APK перед установкой.

---

## 🔍 Как моё приложение появляется в GitHub Store?

GitHub Store не использует приватную индексацию или ручную модерацию.  
Ваш проект может появиться автоматически, если выполняются следующие условия:

1. **Публичный репозиторий на GitHub**
    - Видимость должна быть `public`.

2. **Хотя бы один опубликованный релиз**
    - Создан через GitHub Releases (не просто тег).
    - Последний релиз не должен быть черновиком или prerelease.

3. **Устанавливаемые файлы в последнем релизе**
    - Последний релиз должен содержать хотя бы один файл с поддерживаемым расширением:
        - Android: `.apk`
        - Windows: `.exe`, `.msi`
        - macOS: `.dmg`, `.pkg`
        - Linux: `.deb`, `.rpm`, `.AppImage`
    - Автоматически сгенерированные архивы исходного кода GitHub
      (`Source code (zip)` / `Source code (tar.gz)`) игнорируются.

4. **Доступность через поиск / темы**
    - Репозитории получаются через публичный GitHub Search API.
    - Темы, язык и описание влияют на ранжирование.
    - Наличие хотя бы нескольких звёзд увеличивает шанс появления в разделах Popular / Updated / New.

Если репозиторий соответствует этим условиям, GitHub Store найдёт его автоматически —
никакой ручной отправки не требуется.

---

## 🧭 Как работает GitHub Store (в общих чертах)

1. **Поиск**
    - Используется эндпоинт `/search/repositories` с учётом платформы.
    - Применяется простая система оценки на основе тем, языка и описания.
    - Архивированные репозитории и проекты с недостаточными сигналами отфильтровываются.

2. **Проверка релизов и файлов**
    - Для кандидатов вызывается `/repos/{owner}/{repo}/releases/latest`.
    - Проверяется массив `assets` на наличие файлов для текущей платформы.
    - Если подходящих файлов нет — репозиторий исключается.

3. **Экран деталей**
    - Информация о репозитории: название, владелец, описание, звёзды, форки, issues.
    - Последний релиз: тег, дата публикации, changelog, файлы.
    - README загружается из основной ветки и отображается как «О приложении».

4. **Процесс установки**
    - При нажатии «Install latest»:
        - Выбирается наиболее подходящий файл для текущей платформы.
        - Начинается загрузка.
        - Управление передаётся системному установщику.
        - На Android установка сохраняется в локальной базе и отслеживается.

---

## ⚙️ Технологический стек

- **Минимальный Android SDK: 24**

- **Язык и платформа**
    - Kotlin Multiplatform (Android + JVM Desktop)
    - Compose Multiplatform UI (Material 3, иконки, ресурсы)

- **Асинхронность и состояние**
    - Kotlin Coroutines + Flow
    - AndroidX Lifecycle (ViewModel + Runtime Compose)

- **Сеть и данные**
    - Ktor 3
    - Kotlinx Serialization JSON
    - Kotlinx Datetime
    - Room + KSP (для базы данных установленных приложений на Android)

- **DI**
    - Koin 4

- **Навигация**
    - JetBrains Navigation Compose

- **Аутентификация и безопасность**
    - GitHub OAuth (Device Code Flow)
    - Androidx DataStore

- **Медиа и Markdown**
    - Coil 3
    - multiplatform-markdown-renderer-m3

- **Логирование и инструменты**
    - Kermit
    - Compose Hot Reload (Desktop)
    - ProGuard / R8 + shrink ресурсов

---

## ✅ Почему стоит использовать GitHub Store?

- **Больше не нужно вручную искать релизы**
- **Отслеживание установленных приложений**
- **Всегда последняя версия**
- **Единый опыт на Android и Desktop**
- **Open source и расширяемость**

---

## 💖 Поддержать проект

GitHub Store бесплатен и всегда будет бесплатным.  
Если проект оказался полезным, вы можете поддержать его здесь:

<a href="https://github.com/sponsors/rainxchzed">
  <img src="https://img.shields.io/badge/Sponsor-GitHub-pink?logo=github" alt="Поддержать на GitHub">
</a>

<a href="https://www.buymeacoffee.com/rainxchzed">
  <img src="https://img.shields.io/badge/Buy%20me%20a%20coffee-FFDD00?logo=buy-me-a-coffee&logoColor=black" alt="Купить кофе">
</a>

Ваша поддержка помогает:
- Поддерживать приложение для более чем 20 000 пользователей
- Разрабатывать новые функции
- Создавать больше бесплатных инструментов для разработчиков

Также вы можете поставить ⭐ репозиторию и поделиться им!

---

## ⚠️ Отказ от ответственности

GitHub Store лишь помогает находить и загружать файлы релизов,
опубликованные сторонними разработчиками на GitHub.

Используя GitHub Store, вы понимаете и соглашаетесь с тем, что
устанавливаете и запускаете программное обеспечение на свой страх и риск.

---

## 📄 Лицензия

GitHub Store распространяется по лицензии **Apache License, Version 2.0**.

```
Copyright 2025 rainxchzed

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this project except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```