package zed.rainxch.githubstore.feature.details.presentation.components.states

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import githubstore.composeapp.generated.resources.Res
import githubstore.composeapp.generated.resources.error_loading_details
import githubstore.composeapp.generated.resources.retry
import githubstore.composeapp.generated.resources.update_available
import org.jetbrains.compose.resources.stringResource
import zed.rainxch.githubstore.core.presentation.components.GithubStoreButton
import zed.rainxch.githubstore.feature.details.presentation.DetailsAction

@Composable
fun ErrorState(
    errorMessage: String,
    onAction: (DetailsAction) -> Unit
) {
    Column(
        modifier = Modifier.fillMaxSize(),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Text(
            text = stringResource(Res.string.error_loading_details),
            style = MaterialTheme.typography.titleMedium,
            color = MaterialTheme.colorScheme.onBackground,
            textAlign = TextAlign.Center
        )

        Text(
            text = errorMessage,
            style = MaterialTheme.typography.titleSmall,
            color = MaterialTheme.colorScheme.error,
        )

        GithubStoreButton(
            text = stringResource(Res.string.retry),
            onClick = {
                onAction(DetailsAction.Retry)
            }
        )
    }
}