// Copyright (c) 2019 Ben Hills and the project contributors. Use of this source
// code is governed by a MIT license that can be found in the LICENSE file.

/// An enum that contains the country code for each country.
enum Country {
  none(code: ''),
  afghanistan(code: 'af'),
  alandislands(code: 'ax'),
  albania(code: 'al'),
  algeria(code: 'dz'),
  americansamoa(code: 'as'),
  andorra(code: 'ad'),
  angolia(code: 'ao'),
  anguilla(code: 'ai'),
  antarctica(code: 'aq'),
  antiguaandbarbuda(code: 'ag'),
  argentina(code: 'ar'),
  armenia(code: 'am'),
  aruba(code: 'aw'),
  australia(code: 'au'),
  austria(code: 'at'),
  azerbaijan(code: 'az'),
  bahamas(code: 'bs'),
  bahrain(code: 'bh'),
  bangladesh(code: 'bd'),
  barbados(code: 'bb'),
  belarus(code: 'by'),
  belgium(code: 'be'),
  belize(code: 'bz'),
  benin(code: 'bj'),
  bermuda(code: 'bm'),
  bhutan(code: 'bt'),
  bolivia(code: 'bo'),
  bonaire(code: 'bq'),
  bosniaAndHerzegovina(code: 'ba'),
  botswana(code: 'bw'),
  bouvetisland(code: 'bv'),
  brazil(code: 'br'),
  britishIndianOceanTerrirory(code: 'io'),
  britishVirginIslands(code: 'vg'),
  bruneiDarussalam(code: 'bn'),
  bulgaria(code: 'bg'),
  burkinafaso(code: 'bf'),
  burundi(code: 'bi'),
  caboverde(code: 'cv'),
  cambodia(code: 'kh'),
  cameroon(code: 'cm'),
  canada(code: 'ca'),
  caymanIslands(code: 'ky'),
  centralAfricanRepublic(code: 'cf'),
  chad(code: 'td'),
  chile(code: 'cl'),
  china(code: 'cn'),
  christmasIsland(code: 'cx'),
  cocosIslands(code: 'cc'),
  colombia(code: 'co'),
  comoros(code: 'km'),
  congo(code: 'cg'),
  congoDemocraticRepublicOf(code: 'cd'),
  cookIslands(code: 'ck'),
  costaRica(code: 'cr'),
  coteDivoire(code: 'ci'),
  croatia(code: 'hr'),
  cuba(code: 'cu'),
  curacao(code: 'cw'),
  cyprus(code: 'cy'),
  czechia(code: 'cz'),
  denmark(code: 'dk'),
  djibouti(code: 'dj'),
  dominica(code: 'dm'),
  dominicanRepublic(code: 'do'),
  ecuador(code: 'ec'),
  egypt(code: 'eg'),
  elSalvador(code: 'sv'),
  equatorialGuinea(code: 'gq'),
  eritrea(code: 'er'),
  estonia(code: 'ee'),
  ethiopia(code: 'et'),
  falklandIslands(code: 'fk'),
  faroeIslands(code: 'fo'),
  fiji(code: 'fj'),
  finland(code: 'fi'),
  france(code: 'fr'),
  frenchGuiana(code: 'gf'),
  frenchPolynesia(code: 'pf'),
  frenchSouthernTerritories(code: 'tf'),
  gabon(code: 'ga'),
  gambia(code: 'gm'),
  georgia(code: 'ge'),
  germany(code: 'de'),
  ghana(code: 'gh'),
  gibraltar(code: 'gi'),
  greece(code: 'gr'),
  greenland(code: 'gl'),
  grenada(code: 'gd'),
  guadeloupe(code: 'gp'),
  guam(code: 'gu'),
  guatemala(code: 'gt'),
  guernsey(code: 'gg'),
  guinea(code: 'gn'),
  guineaBissau(code: 'gw'),
  guyana(code: 'gy'),
  haiti(code: 'ht'),
  heardIslandAndMcDonaldIslands(code: 'hm'),
  honduras(code: 'hn'),
  hongKong(code: 'hk'),
  hungary(code: 'hu'),
  iceland(code: 'is'),
  india(code: 'in'),
  indonesia(code: 'id'),
  iran(code: 'ir'),
  iraq(code: 'iq'),
  ireland(code: 'ie'),
  isleOfMan(code: 'im'),
  israel(code: 'il'),
  italy(code: 'it'),
  jamaica(code: 'jm'),
  japan(code: 'jp'),
  jersey(code: 'je'),
  jordan(code: 'jo'),
  kazakhstan(code: 'kz'),
  kenya(code: 'ke'),
  kiribati(code: 'ki'),
  kuwait(code: 'kw'),
  kyrgyzstan(code: 'kg'),
  laos(code: 'la'),
  latvia(code: 'lv'),
  lebanon(code: 'lb'),
  lesotho(code: 'ls'),
  liberia(code: 'lr'),
  libya(code: 'ly'),
  liechtenstein(code: 'li'),
  lithuania(code: 'lt'),
  luxembourg(code: 'lu'),
  macao(code: 'mo'),
  macedonia(code: 'mk'),
  madagascar(code: 'mg'),
  malawi(code: 'mw'),
  malaysia(code: 'my'),
  maldives(code: 'mv'),
  mali(code: 'ml'),
  malta(code: 'mt'),
  marshallIslands(code: 'mh'),
  martinique(code: 'mq'),
  mauritania(code: 'mr'),
  mauritius(code: 'mu'),
  mayotte(code: 'yt'),
  mexico(code: 'mx'),
  micronesia(code: 'fm'),
  moldova(code: 'md'),
  monaco(code: 'mc'),
  mongolia(code: 'mn'),
  montenegro(code: 'me'),
  montserrat(code: 'ms'),
  morocco(code: 'ma'),
  mozambique(code: 'mz'),
  myanmar(code: 'mm'),
  namibia(code: 'na'),
  nauru(code: 'nr'),
  nepal(code: 'np'),
  netherlands(code: 'nl'),
  newCaledonia(code: 'nc'),
  newZealand(code: 'nz'),
  nicaragua(code: 'ni'),
  niger(code: 'ne'),
  nigeria(code: 'ng'),
  niue(code: 'nu'),
  norfolkIsland(code: 'nf'),
  northKorea(code: 'kp'),
  northernMarianaIslands(code: 'mp'),
  norway(code: 'no'),
  oman(code: 'om'),
  pakistan(code: 'pk'),
  palau(code: 'pw'),
  palestine(code: 'ps'),
  panama(code: 'pa'),
  papuaNewGuinea(code: 'pg'),
  paraguay(code: 'py'),
  peru(code: 'pe'),
  philippines(code: 'ph'),
  pitcairn(code: 'pn'),
  poland(code: 'pl'),
  portugal(code: 'pt'),
  puertoRico(code: 'pr'),
  qatar(code: 'qa'),
  reunion(code: 're'),
  romania(code: 'ro'),
  russianFederation(code: 'ru'),
  rwanda(code: 'rw'),
  saintBarthelemy(code: 'bl'),
  saintHelena(code: 'sh'),
  saintKittsAndNevis(code: 'kn'),
  saintLucia(code: 'lc'),
  saintMartin(code: 'mf'),
  saintPierreAndMiquelon(code: 'pm'),
  saintVincentAndTheGrenadines(code: 'vc'),
  samoa(code: 'ws'),
  sanMarino(code: 'sm'),
  saoTomeAndPrincipe(code: 'st'),
  saudiArabia(code: 'sa'),
  senegal(code: 'sn'),
  serbia(code: 'rs'),
  seychelles(code: 'sc'),
  sierraLeone(code: 'sl'),
  singapore(code: 'sg'),
  sintMaarten(code: 'sx'),
  slovakia(code: 'sk'),
  slovenia(code: 'si'),
  solomonIslands(code: 'sb'),
  somalia(code: 'so'),
  southAfrica(code: 'za'),
  southGeorgiaAndTheSouthSandwichIslands(code: 'gs'),
  southKorea(code: 'kr'),
  southSudan(code: 'ss'),
  spain(code: 'es'),
  sriLanka(code: 'lk'),
  sudan(code: 'sd'),
  suriname(code: 'sr'),
  svalbardAndJanMayen(code: 'sj'),
  swaziland(code: 'sz'),
  sweden(code: 'se'),
  switzerland(code: 'ch'),
  syrianArabRepublic(code: 'sy'),
  taiwan(code: 'tw'),
  tajikistan(code: 'tj'),
  tanzania(code: 'tz'),
  thailand(code: 'th'),
  timorLeste(code: 'tl'),
  togo(code: 'tg'),
  tokelau(code: 'tk'),
  tonga(code: 'to'),
  trinidadAndTobago(code: 'tt'),
  tunisia(code: 'tn'),
  turkey(code: 'tr'),
  turkmenistan(code: 'tm'),
  turksAndCaicosIslands(code: 'tc'),
  tuvalu(code: 'tv'),
  uganda(code: 'ug'),
  ukraine(code: 'ua'),
  unitedArabEmirates(code: 'ae'),
  unitedKingdom(code: 'gb'),
  unitedStates(code: 'us'),
  unitedStatesMinorOutlyingIslands(code: 'um'),
  uruguay(code: 'uy'),
  usVirginIslands(code: 'vi'),
  uzbekistan(code: 'uz'),
  vanuatu(code: 'vu'),
  vaticanCity(code: 'va'),
  venezuela(code: 've'),
  vietNam(code: 'vn'),
  wallisAndFutuna(code: 'wf'),
  westernSahara(code: 'eh'),
  yemen(code: 'ye'),
  zambia(code: 'zm'),
  zimbabwe(code: 'zw');

  const Country({required this.code});

  final String code;
}
